/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A real-time log configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealtimeLogConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RealtimeLogConfig.Builder, RealtimeLogConfig> {
    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ARN")
            .getter(getter(RealtimeLogConfig::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(RealtimeLogConfig::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("SamplingRate")
            .getter(getter(RealtimeLogConfig::samplingRate))
            .setter(setter(Builder::samplingRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRate")
                    .unmarshallLocationName("SamplingRate").build()).build();

    private static final SdkField<List<EndPoint>> END_POINTS_FIELD = SdkField
            .<List<EndPoint>> builder(MarshallingType.LIST)
            .memberName("EndPoints")
            .getter(getter(RealtimeLogConfig::endPoints))
            .setter(setter(Builder::endPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPoints")
                    .unmarshallLocationName("EndPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(RealtimeLogConfig::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields")
                    .unmarshallLocationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Field")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Field").unmarshallLocationName("Field").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            SAMPLING_RATE_FIELD, END_POINTS_FIELD, FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final Long samplingRate;

    private final List<EndPoint> endPoints;

    private final List<String> fields;

    private RealtimeLogConfig(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.samplingRate = builder.samplingRate;
        this.endPoints = builder.endPoints;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this real-time log configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this real-time log configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique name of this real-time log configuration.
     * </p>
     * 
     * @return The unique name of this real-time log configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer
     * requests that are represented in the real-time log data. The sampling rate is an integer between 1 and 100,
     * inclusive.
     * </p>
     * 
     * @return The sampling rate for this real-time log configuration. The sampling rate determines the percentage of
     *         viewer requests that are represented in the real-time log data. The sampling rate is an integer between 1
     *         and 100, inclusive.
     */
    public final Long samplingRate() {
        return samplingRate;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndPoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndPoints() {
        return endPoints != null && !(endPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this
     * real-time log configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndPoints} method.
     * </p>
     * 
     * @return Contains information about the Amazon Kinesis data stream where you are sending real-time log data for
     *         this real-time log configuration.
     */
    public final List<EndPoint> endPoints() {
        return endPoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of fields that are included in each real-time log record. In an API response, the fields are provided in
     * the same order in which they are sent to the Amazon Kinesis data stream.
     * </p>
     * <p>
     * For more information about fields, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
     * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A list of fields that are included in each real-time log record. In an API response, the fields are
     *         provided in the same order in which they are sent to the Amazon Kinesis data stream.</p>
     *         <p>
     *         For more information about fields, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
     *         >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final List<String> fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(samplingRate());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndPoints() ? endPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeLogConfig)) {
            return false;
        }
        RealtimeLogConfig other = (RealtimeLogConfig) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(samplingRate(), other.samplingRate()) && hasEndPoints() == other.hasEndPoints()
                && Objects.equals(endPoints(), other.endPoints()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealtimeLogConfig").add("ARN", arn()).add("Name", name()).add("SamplingRate", samplingRate())
                .add("EndPoints", hasEndPoints() ? endPoints() : null).add("Fields", hasFields() ? fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SamplingRate":
            return Optional.ofNullable(clazz.cast(samplingRate()));
        case "EndPoints":
            return Optional.ofNullable(clazz.cast(endPoints()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ARN", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("SamplingRate", SAMPLING_RATE_FIELD);
        map.put("EndPoints", END_POINTS_FIELD);
        map.put("Fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealtimeLogConfig, T> g) {
        return obj -> g.apply((RealtimeLogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealtimeLogConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of this real-time log configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of this real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique name of this real-time log configuration.
         * </p>
         * 
         * @param name
         *        The unique name of this real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer
         * requests that are represented in the real-time log data. The sampling rate is an integer between 1 and 100,
         * inclusive.
         * </p>
         * 
         * @param samplingRate
         *        The sampling rate for this real-time log configuration. The sampling rate determines the percentage of
         *        viewer requests that are represented in the real-time log data. The sampling rate is an integer
         *        between 1 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRate(Long samplingRate);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this
         * real-time log configuration.
         * </p>
         * 
         * @param endPoints
         *        Contains information about the Amazon Kinesis data stream where you are sending real-time log data for
         *        this real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPoints(Collection<EndPoint> endPoints);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this
         * real-time log configuration.
         * </p>
         * 
         * @param endPoints
         *        Contains information about the Amazon Kinesis data stream where you are sending real-time log data for
         *        this real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPoints(EndPoint... endPoints);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this
         * real-time log configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.EndPoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudfront.model.EndPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.EndPoint.Builder#build()} is called immediately and
         * its result is passed to {@link #endPoints(List<EndPoint>)}.
         * 
         * @param endPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.EndPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endPoints(java.util.Collection<EndPoint>)
         */
        Builder endPoints(Consumer<EndPoint.Builder>... endPoints);

        /**
         * <p>
         * A list of fields that are included in each real-time log record. In an API response, the fields are provided
         * in the same order in which they are sent to the Amazon Kinesis data stream.
         * </p>
         * <p>
         * For more information about fields, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param fields
         *        A list of fields that are included in each real-time log record. In an API response, the fields are
         *        provided in the same order in which they are sent to the Amazon Kinesis data stream.</p>
         *        <p>
         *        For more information about fields, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         *        >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<String> fields);

        /**
         * <p>
         * A list of fields that are included in each real-time log record. In an API response, the fields are provided
         * in the same order in which they are sent to the Amazon Kinesis data stream.
         * </p>
         * <p>
         * For more information about fields, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param fields
         *        A list of fields that are included in each real-time log record. In an API response, the fields are
         *        provided in the same order in which they are sent to the Amazon Kinesis data stream.</p>
         *        <p>
         *        For more information about fields, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         *        >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(String... fields);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Long samplingRate;

        private List<EndPoint> endPoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeLogConfig model) {
            arn(model.arn);
            name(model.name);
            samplingRate(model.samplingRate);
            endPoints(model.endPoints);
            fields(model.fields);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getSamplingRate() {
            return samplingRate;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final List<EndPoint.Builder> getEndPoints() {
            List<EndPoint.Builder> result = EndPointListCopier.copyToBuilder(this.endPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndPoints(Collection<EndPoint.BuilderImpl> endPoints) {
            this.endPoints = EndPointListCopier.copyFromBuilder(endPoints);
        }

        @Override
        public final Builder endPoints(Collection<EndPoint> endPoints) {
            this.endPoints = EndPointListCopier.copy(endPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(EndPoint... endPoints) {
            endPoints(Arrays.asList(endPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(Consumer<EndPoint.Builder>... endPoints) {
            endPoints(Stream.of(endPoints).map(c -> EndPoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFields() {
            if (fields instanceof SdkAutoConstructList) {
                return null;
            }
            return fields;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
        }

        @Override
        public final Builder fields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(String... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        public RealtimeLogConfig build() {
            return new RealtimeLogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
