/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key group.
 * </p>
 * <p>
 * A key group contains a list of public keys that you can use with <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs
 * and signed cookies</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyGroup implements SdkPojo, Serializable, ToCopyableBuilder<KeyGroup.Builder, KeyGroup> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(KeyGroup::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(KeyGroup::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<KeyGroupConfig> KEY_GROUP_CONFIG_FIELD = SdkField
            .<KeyGroupConfig> builder(MarshallingType.SDK_POJO)
            .memberName("KeyGroupConfig")
            .getter(getter(KeyGroup::keyGroupConfig))
            .setter(setter(Builder::keyGroupConfig))
            .constructor(KeyGroupConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroupConfig")
                    .unmarshallLocationName("KeyGroupConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, KEY_GROUP_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant lastModifiedTime;

    private final KeyGroupConfig keyGroupConfig;

    private KeyGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.keyGroupConfig = builder.keyGroupConfig;
    }

    /**
     * <p>
     * The identifier for the key group.
     * </p>
     * 
     * @return The identifier for the key group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time when the key group was last modified.
     * </p>
     * 
     * @return The date and time when the key group was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The key group configuration.
     * </p>
     * 
     * @return The key group configuration.
     */
    public final KeyGroupConfig keyGroupConfig() {
        return keyGroupConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(keyGroupConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyGroup)) {
            return false;
        }
        KeyGroup other = (KeyGroup) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(keyGroupConfig(), other.keyGroupConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyGroup").add("Id", id()).add("LastModifiedTime", lastModifiedTime())
                .add("KeyGroupConfig", keyGroupConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "KeyGroupConfig":
            return Optional.ofNullable(clazz.cast(keyGroupConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("KeyGroupConfig", KEY_GROUP_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyGroup, T> g) {
        return obj -> g.apply((KeyGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyGroup> {
        /**
         * <p>
         * The identifier for the key group.
         * </p>
         * 
         * @param id
         *        The identifier for the key group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time when the key group was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time when the key group was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The key group configuration.
         * </p>
         * 
         * @param keyGroupConfig
         *        The key group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyGroupConfig(KeyGroupConfig keyGroupConfig);

        /**
         * <p>
         * The key group configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyGroupConfig.Builder} avoiding the need
         * to create one manually via {@link KeyGroupConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyGroupConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #keyGroupConfig(KeyGroupConfig)}.
         * 
         * @param keyGroupConfig
         *        a consumer that will call methods on {@link KeyGroupConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyGroupConfig(KeyGroupConfig)
         */
        default Builder keyGroupConfig(Consumer<KeyGroupConfig.Builder> keyGroupConfig) {
            return keyGroupConfig(KeyGroupConfig.builder().applyMutation(keyGroupConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedTime;

        private KeyGroupConfig keyGroupConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyGroup model) {
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
            keyGroupConfig(model.keyGroupConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final KeyGroupConfig.Builder getKeyGroupConfig() {
            return keyGroupConfig != null ? keyGroupConfig.toBuilder() : null;
        }

        public final void setKeyGroupConfig(KeyGroupConfig.BuilderImpl keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig != null ? keyGroupConfig.build() : null;
        }

        @Override
        public final Builder keyGroupConfig(KeyGroupConfig keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig;
            return this;
        }

        @Override
        public KeyGroup build() {
            return new KeyGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
