/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFieldLevelEncryptionConfigResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetFieldLevelEncryptionConfigResponse.Builder, GetFieldLevelEncryptionConfigResponse> {
    private static final SdkField<FieldLevelEncryptionConfig> FIELD_LEVEL_ENCRYPTION_CONFIG_FIELD = SdkField
            .<FieldLevelEncryptionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("FieldLevelEncryptionConfig")
            .getter(getter(GetFieldLevelEncryptionConfigResponse::fieldLevelEncryptionConfig))
            .setter(setter(Builder::fieldLevelEncryptionConfig))
            .constructor(FieldLevelEncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionConfig")
                    .unmarshallLocationName("FieldLevelEncryptionConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetFieldLevelEncryptionConfigResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FIELD_LEVEL_ENCRYPTION_CONFIG_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FieldLevelEncryptionConfig fieldLevelEncryptionConfig;

    private final String eTag;

    private GetFieldLevelEncryptionConfigResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryptionConfig = builder.fieldLevelEncryptionConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Return the field-level encryption configuration information.
     * </p>
     * 
     * @return Return the field-level encryption configuration information.
     */
    public final FieldLevelEncryptionConfig fieldLevelEncryptionConfig() {
        return fieldLevelEncryptionConfig;
    }

    /**
     * <p>
     * The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>
     *         .
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFieldLevelEncryptionConfigResponse)) {
            return false;
        }
        GetFieldLevelEncryptionConfigResponse other = (GetFieldLevelEncryptionConfigResponse) obj;
        return Objects.equals(fieldLevelEncryptionConfig(), other.fieldLevelEncryptionConfig())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFieldLevelEncryptionConfigResponse")
                .add("FieldLevelEncryptionConfig", fieldLevelEncryptionConfig()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLevelEncryptionConfig":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionConfig()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldLevelEncryptionConfig", FIELD_LEVEL_ENCRYPTION_CONFIG_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFieldLevelEncryptionConfigResponse, T> g) {
        return obj -> g.apply((GetFieldLevelEncryptionConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFieldLevelEncryptionConfigResponse> {
        /**
         * <p>
         * Return the field-level encryption configuration information.
         * </p>
         * 
         * @param fieldLevelEncryptionConfig
         *        Return the field-level encryption configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionConfig(FieldLevelEncryptionConfig fieldLevelEncryptionConfig);

        /**
         * <p>
         * Return the field-level encryption configuration information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldLevelEncryptionConfig.Builder}
         * avoiding the need to create one manually via {@link FieldLevelEncryptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldLevelEncryptionConfig(FieldLevelEncryptionConfig)}.
         * 
         * @param fieldLevelEncryptionConfig
         *        a consumer that will call methods on {@link FieldLevelEncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionConfig(FieldLevelEncryptionConfig)
         */
        default Builder fieldLevelEncryptionConfig(Consumer<FieldLevelEncryptionConfig.Builder> fieldLevelEncryptionConfig) {
            return fieldLevelEncryptionConfig(FieldLevelEncryptionConfig.builder().applyMutation(fieldLevelEncryptionConfig)
                    .build());
        }

        /**
         * <p>
         * The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the field level encryption configuration. For example:
         *        <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FieldLevelEncryptionConfig fieldLevelEncryptionConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFieldLevelEncryptionConfigResponse model) {
            super(model);
            fieldLevelEncryptionConfig(model.fieldLevelEncryptionConfig);
            eTag(model.eTag);
        }

        public final FieldLevelEncryptionConfig.Builder getFieldLevelEncryptionConfig() {
            return fieldLevelEncryptionConfig != null ? fieldLevelEncryptionConfig.toBuilder() : null;
        }

        public final void setFieldLevelEncryptionConfig(FieldLevelEncryptionConfig.BuilderImpl fieldLevelEncryptionConfig) {
            this.fieldLevelEncryptionConfig = fieldLevelEncryptionConfig != null ? fieldLevelEncryptionConfig.build() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionConfig(FieldLevelEncryptionConfig fieldLevelEncryptionConfig) {
            this.fieldLevelEncryptionConfig = fieldLevelEncryptionConfig;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetFieldLevelEncryptionConfigResponse build() {
            return new GetFieldLevelEncryptionConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
