/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the information about a CloudFront distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DistributionSummary.Builder, DistributionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(DistributionSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ARN")
            .getter(getter(DistributionSummary::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(DistributionSummary::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(DistributionSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DomainName")
            .getter(getter(DistributionSummary::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName")
                    .unmarshallLocationName("DomainName").build()).build();

    private static final SdkField<Aliases> ALIASES_FIELD = SdkField
            .<Aliases> builder(MarshallingType.SDK_POJO)
            .memberName("Aliases")
            .getter(getter(DistributionSummary::aliases))
            .setter(setter(Builder::aliases))
            .constructor(Aliases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases")
                    .unmarshallLocationName("Aliases").build()).build();

    private static final SdkField<Origins> ORIGINS_FIELD = SdkField
            .<Origins> builder(MarshallingType.SDK_POJO)
            .memberName("Origins")
            .getter(getter(DistributionSummary::origins))
            .setter(setter(Builder::origins))
            .constructor(Origins::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins")
                    .unmarshallLocationName("Origins").build()).build();

    private static final SdkField<OriginGroups> ORIGIN_GROUPS_FIELD = SdkField
            .<OriginGroups> builder(MarshallingType.SDK_POJO)
            .memberName("OriginGroups")
            .getter(getter(DistributionSummary::originGroups))
            .setter(setter(Builder::originGroups))
            .constructor(OriginGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginGroups")
                    .unmarshallLocationName("OriginGroups").build()).build();

    private static final SdkField<DefaultCacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField
            .<DefaultCacheBehavior> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultCacheBehavior")
            .getter(getter(DistributionSummary::defaultCacheBehavior))
            .setter(setter(Builder::defaultCacheBehavior))
            .constructor(DefaultCacheBehavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCacheBehavior")
                    .unmarshallLocationName("DefaultCacheBehavior").build()).build();

    private static final SdkField<CacheBehaviors> CACHE_BEHAVIORS_FIELD = SdkField
            .<CacheBehaviors> builder(MarshallingType.SDK_POJO)
            .memberName("CacheBehaviors")
            .getter(getter(DistributionSummary::cacheBehaviors))
            .setter(setter(Builder::cacheBehaviors))
            .constructor(CacheBehaviors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheBehaviors")
                    .unmarshallLocationName("CacheBehaviors").build()).build();

    private static final SdkField<CustomErrorResponses> CUSTOM_ERROR_RESPONSES_FIELD = SdkField
            .<CustomErrorResponses> builder(MarshallingType.SDK_POJO)
            .memberName("CustomErrorResponses")
            .getter(getter(DistributionSummary::customErrorResponses))
            .setter(setter(Builder::customErrorResponses))
            .constructor(CustomErrorResponses::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomErrorResponses")
                    .unmarshallLocationName("CustomErrorResponses").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(DistributionSummary::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<String> PRICE_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PriceClass")
            .getter(getter(DistributionSummary::priceClassAsString))
            .setter(setter(Builder::priceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceClass")
                    .unmarshallLocationName("PriceClass").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(DistributionSummary::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<ViewerCertificate> VIEWER_CERTIFICATE_FIELD = SdkField
            .<ViewerCertificate> builder(MarshallingType.SDK_POJO)
            .memberName("ViewerCertificate")
            .getter(getter(DistributionSummary::viewerCertificate))
            .setter(setter(Builder::viewerCertificate))
            .constructor(ViewerCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerCertificate")
                    .unmarshallLocationName("ViewerCertificate").build()).build();

    private static final SdkField<Restrictions> RESTRICTIONS_FIELD = SdkField
            .<Restrictions> builder(MarshallingType.SDK_POJO)
            .memberName("Restrictions")
            .getter(getter(DistributionSummary::restrictions))
            .setter(setter(Builder::restrictions))
            .constructor(Restrictions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions")
                    .unmarshallLocationName("Restrictions").build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WebACLId")
            .getter(getter(DistributionSummary::webACLId))
            .setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId")
                    .unmarshallLocationName("WebACLId").build()).build();

    private static final SdkField<String> HTTP_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpVersion")
            .getter(getter(DistributionSummary::httpVersionAsString))
            .setter(setter(Builder::httpVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpVersion")
                    .unmarshallLocationName("HttpVersion").build()).build();

    private static final SdkField<Boolean> IS_IPV6_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsIPV6Enabled")
            .getter(getter(DistributionSummary::isIPV6Enabled))
            .setter(setter(Builder::isIPV6Enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIPV6Enabled")
                    .unmarshallLocationName("IsIPV6Enabled").build()).build();

    private static final SdkField<List<AliasICPRecordal>> ALIAS_ICP_RECORDALS_FIELD = SdkField
            .<List<AliasICPRecordal>> builder(MarshallingType.LIST)
            .memberName("AliasICPRecordals")
            .getter(getter(DistributionSummary::aliasICPRecordals))
            .setter(setter(Builder::aliasICPRecordals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasICPRecordals")
                    .unmarshallLocationName("AliasICPRecordals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AliasICPRecordal")
                            .memberFieldInfo(
                                    SdkField.<AliasICPRecordal> builder(MarshallingType.SDK_POJO)
                                            .constructor(AliasICPRecordal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AliasICPRecordal").unmarshallLocationName("AliasICPRecordal")
                                                    .build()).build()).build()).build();

    private static final SdkField<Boolean> STAGING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Staging")
            .getter(getter(DistributionSummary::staging))
            .setter(setter(Builder::staging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Staging")
                    .unmarshallLocationName("Staging").build()).build();

    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnycastIpListId")
            .getter(getter(DistributionSummary::anycastIpListId))
            .setter(setter(Builder::anycastIpListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId")
                    .unmarshallLocationName("AnycastIpListId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, DOMAIN_NAME_FIELD, ALIASES_FIELD, ORIGINS_FIELD, ORIGIN_GROUPS_FIELD,
            DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIORS_FIELD, CUSTOM_ERROR_RESPONSES_FIELD, COMMENT_FIELD, PRICE_CLASS_FIELD,
            ENABLED_FIELD, VIEWER_CERTIFICATE_FIELD, RESTRICTIONS_FIELD, WEB_ACL_ID_FIELD, HTTP_VERSION_FIELD,
            IS_IPV6_ENABLED_FIELD, ALIAS_ICP_RECORDALS_FIELD, STAGING_FIELD, ANYCAST_IP_LIST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final Aliases aliases;

    private final Origins origins;

    private final OriginGroups originGroups;

    private final DefaultCacheBehavior defaultCacheBehavior;

    private final CacheBehaviors cacheBehaviors;

    private final CustomErrorResponses customErrorResponses;

    private final String comment;

    private final String priceClass;

    private final Boolean enabled;

    private final ViewerCertificate viewerCertificate;

    private final Restrictions restrictions;

    private final String webACLId;

    private final String httpVersion;

    private final Boolean isIPV6Enabled;

    private final List<AliasICPRecordal> aliasICPRecordals;

    private final Boolean staging;

    private final String anycastIpListId;

    private DistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.aliases = builder.aliases;
        this.origins = builder.origins;
        this.originGroups = builder.originGroups;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
        this.aliasICPRecordals = builder.aliasICPRecordals;
        this.staging = builder.staging;
        this.anycastIpListId = builder.anycastIpListId;
    }

    /**
     * <p>
     * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is
     * your Amazon Web Services account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your Amazon Web Services account ID.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the distribution. When the status is <code>Deployed</code>, the distribution's information
     * is propagated to all CloudFront edge locations.
     * </p>
     * 
     * @return The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
     *         information is propagated to all CloudFront edge locations.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the distribution was last modified.
     * </p>
     * 
     * @return The date and time the distribution was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name that corresponds to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name that corresponds to the distribution, for example,
     *         <code>d111111abcdef8.cloudfront.net</code>.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         distribution.
     */
    public final Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * A complex type that contains information about origins for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origins for this distribution.
     */
    public final Origins origins() {
        return origins;
    }

    /**
     * <p>
     * A complex type that contains information about origin groups for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origin groups for this distribution.
     */
    public final OriginGroups originGroups() {
        return originGroups;
    }

    /**
     * <p>
     * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
     * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
     * elements. You must create exactly one default cache behavior.
     * </p>
     * 
     * @return A complex type that describes the default cache behavior if you don't specify a
     *         <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code>
     *         in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.
     */
    public final DefaultCacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CacheBehavior</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CacheBehavior</code> elements.
     */
    public final CacheBehaviors cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
     */
    public final CustomErrorResponses customErrorResponses() {
        return customErrorResponses;
    }

    /**
     * <p>
     * The comment originally specified when this distribution was created.
     * </p>
     * 
     * @return The comment originally specified when this distribution was created.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public final PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public final String priceClassAsString() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the distribution is enabled to accept user requests for content.
     * </p>
     * 
     * @return Whether the distribution is enabled to accept user requests for content.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     * </p>
     * 
     * @return A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     */
    public final ViewerCertificate viewerCertificate() {
        return viewerCertificate;
    }

    /**
     * <p>
     * A complex type that identifies ways in which you want to restrict distribution of your content.
     * </p>
     * 
     * @return A complex type that identifies ways in which you want to restrict distribution of your content.
     */
    public final Restrictions restrictions() {
        return restrictions;
    }

    /**
     * <p>
     * The Web ACL Id (if any) associated with the distribution.
     * </p>
     * 
     * @return The Web ACL Id (if any) associated with the distribution.
     */
    public final String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value
     * for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
     * automatically use an earlier version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionAsString}.
     * </p>
     * 
     * @return Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
     *         value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code>
     *         will automatically use an earlier version.
     * @see HttpVersion
     */
    public final HttpVersion httpVersion() {
        return HttpVersion.fromValue(httpVersion);
    }

    /**
     * <p>
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value
     * for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
     * automatically use an earlier version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionAsString}.
     * </p>
     * 
     * @return Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
     *         value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code>
     *         will automatically use an earlier version.
     * @see HttpVersion
     */
    public final String httpVersionAsString() {
        return httpVersion;
    }

    /**
     * <p>
     * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
     * </p>
     * 
     * @return Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
     */
    public final Boolean isIPV6Enabled() {
        return isIPV6Enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the AliasICPRecordals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAliasICPRecordals() {
        return aliasICPRecordals != null && !(aliasICPRecordals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they
     * want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to
     * CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
     * </p>
     * <p>
     * For more information about ICP recordals, see <a
     * href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts, and
     * Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliasICPRecordals} method.
     * </p>
     * 
     * @return Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal
     *         if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've
     *         added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with
     *         distributions.</p>
     *         <p>
     *         For more information about ICP recordals, see <a
     *         href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup,
     *         Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.
     */
    public final List<AliasICPRecordal> aliasICPRecordals() {
        return aliasICPRecordals;
    }

    /**
     * <p>
     * A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>, this is a
     * staging distribution. When this value is <code>false</code>, this is not a staging distribution.
     * </p>
     * 
     * @return A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>,
     *         this is a staging distribution. When this value is <code>false</code>, this is not a staging
     *         distribution.
     */
    public final Boolean staging() {
        return staging;
    }

    /**
     * <p>
     * ID of the Anycast static IP list that is associated with the distribution.
     * </p>
     * 
     * @return ID of the Anycast static IP list that is associated with the distribution.
     */
    public final String anycastIpListId() {
        return anycastIpListId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(origins());
        hashCode = 31 * hashCode + Objects.hashCode(originGroups());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(httpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isIPV6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasAliasICPRecordals() ? aliasICPRecordals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(staging());
        hashCode = 31 * hashCode + Objects.hashCode(anycastIpListId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionSummary)) {
            return false;
        }
        DistributionSummary other = (DistributionSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(aliases(), other.aliases())
                && Objects.equals(origins(), other.origins()) && Objects.equals(originGroups(), other.originGroups())
                && Objects.equals(defaultCacheBehavior(), other.defaultCacheBehavior())
                && Objects.equals(cacheBehaviors(), other.cacheBehaviors())
                && Objects.equals(customErrorResponses(), other.customErrorResponses())
                && Objects.equals(comment(), other.comment()) && Objects.equals(priceClassAsString(), other.priceClassAsString())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(viewerCertificate(), other.viewerCertificate())
                && Objects.equals(restrictions(), other.restrictions()) && Objects.equals(webACLId(), other.webACLId())
                && Objects.equals(httpVersionAsString(), other.httpVersionAsString())
                && Objects.equals(isIPV6Enabled(), other.isIPV6Enabled())
                && hasAliasICPRecordals() == other.hasAliasICPRecordals()
                && Objects.equals(aliasICPRecordals(), other.aliasICPRecordals()) && Objects.equals(staging(), other.staging())
                && Objects.equals(anycastIpListId(), other.anycastIpListId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DistributionSummary").add("Id", id()).add("ARN", arn()).add("Status", status())
                .add("LastModifiedTime", lastModifiedTime()).add("DomainName", domainName()).add("Aliases", aliases())
                .add("Origins", origins()).add("OriginGroups", originGroups())
                .add("DefaultCacheBehavior", defaultCacheBehavior()).add("CacheBehaviors", cacheBehaviors())
                .add("CustomErrorResponses", customErrorResponses()).add("Comment", comment())
                .add("PriceClass", priceClassAsString()).add("Enabled", enabled()).add("ViewerCertificate", viewerCertificate())
                .add("Restrictions", restrictions()).add("WebACLId", webACLId()).add("HttpVersion", httpVersionAsString())
                .add("IsIPV6Enabled", isIPV6Enabled())
                .add("AliasICPRecordals", hasAliasICPRecordals() ? aliasICPRecordals() : null).add("Staging", staging())
                .add("AnycastIpListId", anycastIpListId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        case "Origins":
            return Optional.ofNullable(clazz.cast(origins()));
        case "OriginGroups":
            return Optional.ofNullable(clazz.cast(originGroups()));
        case "DefaultCacheBehavior":
            return Optional.ofNullable(clazz.cast(defaultCacheBehavior()));
        case "CacheBehaviors":
            return Optional.ofNullable(clazz.cast(cacheBehaviors()));
        case "CustomErrorResponses":
            return Optional.ofNullable(clazz.cast(customErrorResponses()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "PriceClass":
            return Optional.ofNullable(clazz.cast(priceClassAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "ViewerCertificate":
            return Optional.ofNullable(clazz.cast(viewerCertificate()));
        case "Restrictions":
            return Optional.ofNullable(clazz.cast(restrictions()));
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        case "HttpVersion":
            return Optional.ofNullable(clazz.cast(httpVersionAsString()));
        case "IsIPV6Enabled":
            return Optional.ofNullable(clazz.cast(isIPV6Enabled()));
        case "AliasICPRecordals":
            return Optional.ofNullable(clazz.cast(aliasICPRecordals()));
        case "Staging":
            return Optional.ofNullable(clazz.cast(staging()));
        case "AnycastIpListId":
            return Optional.ofNullable(clazz.cast(anycastIpListId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Aliases", ALIASES_FIELD);
        map.put("Origins", ORIGINS_FIELD);
        map.put("OriginGroups", ORIGIN_GROUPS_FIELD);
        map.put("DefaultCacheBehavior", DEFAULT_CACHE_BEHAVIOR_FIELD);
        map.put("CacheBehaviors", CACHE_BEHAVIORS_FIELD);
        map.put("CustomErrorResponses", CUSTOM_ERROR_RESPONSES_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("PriceClass", PRICE_CLASS_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("ViewerCertificate", VIEWER_CERTIFICATE_FIELD);
        map.put("Restrictions", RESTRICTIONS_FIELD);
        map.put("WebACLId", WEB_ACL_ID_FIELD);
        map.put("HttpVersion", HTTP_VERSION_FIELD);
        map.put("IsIPV6Enabled", IS_IPV6_ENABLED_FIELD);
        map.put("AliasICPRecordals", ALIAS_ICP_RECORDALS_FIELD);
        map.put("Staging", STAGING_FIELD);
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributionSummary, T> g) {
        return obj -> g.apply((DistributionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistributionSummary> {
        /**
         * <p>
         * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code>
         * is your Amazon Web Services account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
         * information is propagated to all CloudFront edge locations.
         * </p>
         * 
         * @param status
         *        The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
         *        information is propagated to all CloudFront edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name that corresponds to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>
         * .
         * </p>
         * 
         * @param domainName
         *        The domain name that corresponds to the distribution, for example,
         *        <code>d111111abcdef8.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link Aliases.Builder} avoiding the need to
         * create one manually via {@link Aliases#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().applyMutation(aliases).build());
        }

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * 
         * @param origins
         *        A complex type that contains information about origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origins(Origins origins);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link Origins.Builder} avoiding the need to
         * create one manually via {@link Origins#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Origins.Builder#build()} is called immediately and its result is
         * passed to {@link #origins(Origins)}.
         * 
         * @param origins
         *        a consumer that will call methods on {@link Origins.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origins(Origins)
         */
        default Builder origins(Consumer<Origins.Builder> origins) {
            return origins(Origins.builder().applyMutation(origins).build());
        }

        /**
         * <p>
         * A complex type that contains information about origin groups for this distribution.
         * </p>
         * 
         * @param originGroups
         *        A complex type that contains information about origin groups for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originGroups(OriginGroups originGroups);

        /**
         * <p>
         * A complex type that contains information about origin groups for this distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginGroups.Builder} avoiding the need
         * to create one manually via {@link OriginGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #originGroups(OriginGroups)}.
         * 
         * @param originGroups
         *        a consumer that will call methods on {@link OriginGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originGroups(OriginGroups)
         */
        default Builder originGroups(Consumer<OriginGroups.Builder> originGroups) {
            return originGroups(OriginGroups.builder().applyMutation(originGroups).build());
        }

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        A complex type that describes the default cache behavior if you don't specify a
         *        <code>CacheBehavior</code> element or if files don't match any of the values of
         *        <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default
         *        cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultCacheBehavior.Builder} avoiding
         * the need to create one manually via {@link DefaultCacheBehavior#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultCacheBehavior.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultCacheBehavior(DefaultCacheBehavior)}.
         * 
         * @param defaultCacheBehavior
         *        a consumer that will call methods on {@link DefaultCacheBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCacheBehavior(DefaultCacheBehavior)
         */
        default Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return defaultCacheBehavior(DefaultCacheBehavior.builder().applyMutation(defaultCacheBehavior).build());
        }

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * 
         * @param cacheBehaviors
         *        A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(CacheBehaviors cacheBehaviors);

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheBehaviors.Builder} avoiding the need
         * to create one manually via {@link CacheBehaviors#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheBehaviors.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheBehaviors(CacheBehaviors)}.
         * 
         * @param cacheBehaviors
         *        a consumer that will call methods on {@link CacheBehaviors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviors(CacheBehaviors)
         */
        default Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return cacheBehaviors(CacheBehaviors.builder().applyMutation(cacheBehaviors).build());
        }

        /**
         * <p>
         * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * </p>
         * 
         * @param customErrorResponses
         *        A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customErrorResponses(CustomErrorResponses customErrorResponses);

        /**
         * <p>
         * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomErrorResponses.Builder} avoiding
         * the need to create one manually via {@link CustomErrorResponses#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomErrorResponses.Builder#build()} is called immediately and
         * its result is passed to {@link #customErrorResponses(CustomErrorResponses)}.
         * 
         * @param customErrorResponses
         *        a consumer that will call methods on {@link CustomErrorResponses.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customErrorResponses(CustomErrorResponses)
         */
        default Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return customErrorResponses(CustomErrorResponses.builder().applyMutation(customErrorResponses).build());
        }

        /**
         * <p>
         * The comment originally specified when this distribution was created.
         * </p>
         * 
         * @param comment
         *        The comment originally specified when this distribution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the distribution is enabled to accept user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the distribution is enabled to accept user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         * </p>
         * 
         * @param viewerCertificate
         *        A complex type that determines the distribution's SSL/TLS configuration for communicating with
         *        viewers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCertificate(ViewerCertificate viewerCertificate);

        /**
         * <p>
         * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewerCertificate.Builder} avoiding the
         * need to create one manually via {@link ViewerCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewerCertificate.Builder#build()} is called immediately and its
         * result is passed to {@link #viewerCertificate(ViewerCertificate)}.
         * 
         * @param viewerCertificate
         *        a consumer that will call methods on {@link ViewerCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewerCertificate(ViewerCertificate)
         */
        default Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return viewerCertificate(ViewerCertificate.builder().applyMutation(viewerCertificate).build());
        }

        /**
         * <p>
         * A complex type that identifies ways in which you want to restrict distribution of your content.
         * </p>
         * 
         * @param restrictions
         *        A complex type that identifies ways in which you want to restrict distribution of your content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(Restrictions restrictions);

        /**
         * <p>
         * A complex type that identifies ways in which you want to restrict distribution of your content.
         * </p>
         * This is a convenience method that creates an instance of the {@link Restrictions.Builder} avoiding the need
         * to create one manually via {@link Restrictions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Restrictions.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictions(Restrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link Restrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(Restrictions)
         */
        default Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return restrictions(Restrictions.builder().applyMutation(restrictions).build());
        }

        /**
         * <p>
         * The Web ACL Id (if any) associated with the distribution.
         * </p>
         * 
         * @param webACLId
         *        The Web ACL Id (if any) associated with the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
         * value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
         * automatically use an earlier version.
         * </p>
         * 
         * @param httpVersion
         *        Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         *        default value for new web distributions is <code>http2</code>. Viewers that don't support
         *        <code>HTTP/2</code> will automatically use an earlier version.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(String httpVersion);

        /**
         * <p>
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
         * value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
         * automatically use an earlier version.
         * </p>
         * 
         * @param httpVersion
         *        Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         *        default value for new web distributions is <code>http2</code>. Viewers that don't support
         *        <code>HTTP/2</code> will automatically use an earlier version.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(HttpVersion httpVersion);

        /**
         * <p>
         * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
         * </p>
         * 
         * @param isIPV6Enabled
         *        Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIPV6Enabled(Boolean isIPV6Enabled);

        /**
         * <p>
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if
         * they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to
         * CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
         * </p>
         * <p>
         * For more information about ICP recordals, see <a
         * href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts,
         * and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.
         * </p>
         * 
         * @param aliasICPRecordals
         *        Amazon Web Services services in China customers must file for an Internet Content Provider (ICP)
         *        recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME,
         *        that they've added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs
         *        associated with distributions.</p>
         *        <p>
         *        For more information about ICP recordals, see <a
         *        href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup,
         *        Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasICPRecordals(Collection<AliasICPRecordal> aliasICPRecordals);

        /**
         * <p>
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if
         * they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to
         * CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
         * </p>
         * <p>
         * For more information about ICP recordals, see <a
         * href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts,
         * and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.
         * </p>
         * 
         * @param aliasICPRecordals
         *        Amazon Web Services services in China customers must file for an Internet Content Provider (ICP)
         *        recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME,
         *        that they've added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs
         *        associated with distributions.</p>
         *        <p>
         *        For more information about ICP recordals, see <a
         *        href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup,
         *        Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasICPRecordals(AliasICPRecordal... aliasICPRecordals);

        /**
         * <p>
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if
         * they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to
         * CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
         * </p>
         * <p>
         * For more information about ICP recordals, see <a
         * href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts,
         * and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal.Builder#build()} is called
         * immediately and its result is passed to {@link #aliasICPRecordals(List<AliasICPRecordal>)}.
         * 
         * @param aliasICPRecordals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliasICPRecordals(java.util.Collection<AliasICPRecordal>)
         */
        Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder>... aliasICPRecordals);

        /**
         * <p>
         * A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>, this
         * is a staging distribution. When this value is <code>false</code>, this is not a staging distribution.
         * </p>
         * 
         * @param staging
         *        A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>,
         *        this is a staging distribution. When this value is <code>false</code>, this is not a staging
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staging(Boolean staging);

        /**
         * <p>
         * ID of the Anycast static IP list that is associated with the distribution.
         * </p>
         * 
         * @param anycastIpListId
         *        ID of the Anycast static IP list that is associated with the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anycastIpListId(String anycastIpListId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private Aliases aliases;

        private Origins origins;

        private OriginGroups originGroups;

        private DefaultCacheBehavior defaultCacheBehavior;

        private CacheBehaviors cacheBehaviors;

        private CustomErrorResponses customErrorResponses;

        private String comment;

        private String priceClass;

        private Boolean enabled;

        private ViewerCertificate viewerCertificate;

        private Restrictions restrictions;

        private String webACLId;

        private String httpVersion;

        private Boolean isIPV6Enabled;

        private List<AliasICPRecordal> aliasICPRecordals = DefaultSdkAutoConstructList.getInstance();

        private Boolean staging;

        private String anycastIpListId;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionSummary model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            domainName(model.domainName);
            aliases(model.aliases);
            origins(model.origins);
            originGroups(model.originGroups);
            defaultCacheBehavior(model.defaultCacheBehavior);
            cacheBehaviors(model.cacheBehaviors);
            customErrorResponses(model.customErrorResponses);
            comment(model.comment);
            priceClass(model.priceClass);
            enabled(model.enabled);
            viewerCertificate(model.viewerCertificate);
            restrictions(model.restrictions);
            webACLId(model.webACLId);
            httpVersion(model.httpVersion);
            isIPV6Enabled(model.isIPV6Enabled);
            aliasICPRecordals(model.aliasICPRecordals);
            staging(model.staging);
            anycastIpListId(model.anycastIpListId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final Origins.Builder getOrigins() {
            return origins != null ? origins.toBuilder() : null;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final OriginGroups.Builder getOriginGroups() {
            return originGroups != null ? originGroups.toBuilder() : null;
        }

        public final void setOriginGroups(OriginGroups.BuilderImpl originGroups) {
            this.originGroups = originGroups != null ? originGroups.build() : null;
        }

        @Override
        public final Builder originGroups(OriginGroups originGroups) {
            this.originGroups = originGroups;
            return this;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return defaultCacheBehavior != null ? defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return cacheBehaviors != null ? cacheBehaviors.toBuilder() : null;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return customErrorResponses != null ? customErrorResponses.toBuilder() : null;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass == null ? null : priceClass.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return viewerCertificate != null ? viewerCertificate.toBuilder() : null;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final Restrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getHttpVersion() {
            return httpVersion;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion == null ? null : httpVersion.toString());
            return this;
        }

        public final Boolean getIsIPV6Enabled() {
            return isIPV6Enabled;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final List<AliasICPRecordal.Builder> getAliasICPRecordals() {
            List<AliasICPRecordal.Builder> result = AliasICPRecordalsCopier.copyToBuilder(this.aliasICPRecordals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliasICPRecordals(Collection<AliasICPRecordal.BuilderImpl> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copyFromBuilder(aliasICPRecordals);
        }

        @Override
        public final Builder aliasICPRecordals(Collection<AliasICPRecordal> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copy(aliasICPRecordals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(AliasICPRecordal... aliasICPRecordals) {
            aliasICPRecordals(Arrays.asList(aliasICPRecordals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder>... aliasICPRecordals) {
            aliasICPRecordals(Stream.of(aliasICPRecordals).map(c -> AliasICPRecordal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getStaging() {
            return staging;
        }

        public final void setStaging(Boolean staging) {
            this.staging = staging;
        }

        @Override
        public final Builder staging(Boolean staging) {
            this.staging = staging;
            return this;
        }

        public final String getAnycastIpListId() {
            return anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        @Override
        public DistributionSummary build() {
            return new DistributionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
