/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFunctionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetFunctionResponse> {
    private static final SdkField<SdkBytes> FUNCTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("FunctionCode").getter(GetFunctionResponse.getter(GetFunctionResponse::functionCode)).setter(GetFunctionResponse.setter(Builder::functionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionCode").unmarshallLocationName("FunctionCode").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetFunctionResponse.getter(GetFunctionResponse::eTag)).setter(GetFunctionResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(GetFunctionResponse.getter(GetFunctionResponse::contentType)).setter(GetFunctionResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").unmarshallLocationName("Content-Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_CODE_FIELD, E_TAG_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFunctionResponse.memberNameToFieldInitializer();
    private final SdkBytes functionCode;
    private final String eTag;
    private final String contentType;

    private GetFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.functionCode = builder.functionCode;
        this.eTag = builder.eTag;
        this.contentType = builder.contentType;
    }

    public final SdkBytes functionCode() {
        return this.functionCode;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String contentType() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResponse)) {
            return false;
        }
        GetFunctionResponse other = (GetFunctionResponse)((Object)obj);
        return Objects.equals(this.functionCode(), other.functionCode()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.contentType(), other.contentType());
    }

    public final String toString() {
        return ToString.builder((String)"GetFunctionResponse").add("FunctionCode", (Object)(this.functionCode() == null ? null : "*** Sensitive Data Redacted ***")).add("ETag", (Object)this.eTag()).add("ContentType", (Object)this.contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionCode": {
                return Optional.ofNullable(clazz.cast(this.functionCode()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionCode", FUNCTION_CODE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionResponse, T> g) {
        return obj -> g.apply((GetFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private SdkBytes functionCode;
        private String eTag;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionResponse model) {
            super(model);
            this.functionCode(model.functionCode);
            this.eTag(model.eTag);
            this.contentType(model.contentType);
        }

        public final ByteBuffer getFunctionCode() {
            return this.functionCode == null ? null : this.functionCode.asByteBuffer();
        }

        public final void setFunctionCode(ByteBuffer functionCode) {
            this.functionCode(functionCode == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)functionCode));
        }

        @Override
        public final Builder functionCode(SdkBytes functionCode) {
            this.functionCode = functionCode;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public GetFunctionResponse build() {
            return new GetFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFunctionResponse> {
        public Builder functionCode(SdkBytes var1);

        public Builder eTag(String var1);

        public Builder contentType(String var1);
    }
}

