/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOriginAccessControlsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListOriginAccessControlsResponse> {
    private static final SdkField<OriginAccessControlList> ORIGIN_ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginAccessControlList").getter(ListOriginAccessControlsResponse.getter(ListOriginAccessControlsResponse::originAccessControlList)).setter(ListOriginAccessControlsResponse.setter(Builder::originAccessControlList)).constructor(OriginAccessControlList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlList").unmarshallLocationName("OriginAccessControlList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_CONTROL_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OriginAccessControlList", ORIGIN_ACCESS_CONTROL_LIST_FIELD);
        }
    });
    private final OriginAccessControlList originAccessControlList;

    private ListOriginAccessControlsResponse(BuilderImpl builder) {
        super(builder);
        this.originAccessControlList = builder.originAccessControlList;
    }

    public final OriginAccessControlList originAccessControlList() {
        return this.originAccessControlList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessControlList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginAccessControlsResponse)) {
            return false;
        }
        ListOriginAccessControlsResponse other = (ListOriginAccessControlsResponse)((Object)obj);
        return Objects.equals(this.originAccessControlList(), other.originAccessControlList());
    }

    public final String toString() {
        return ToString.builder((String)"ListOriginAccessControlsResponse").add("OriginAccessControlList", (Object)this.originAccessControlList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginAccessControlList": {
                return Optional.ofNullable(clazz.cast(this.originAccessControlList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListOriginAccessControlsResponse, T> g) {
        return obj -> g.apply((ListOriginAccessControlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private OriginAccessControlList originAccessControlList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOriginAccessControlsResponse model) {
            super(model);
            this.originAccessControlList(model.originAccessControlList);
        }

        public final OriginAccessControlList.Builder getOriginAccessControlList() {
            return this.originAccessControlList != null ? this.originAccessControlList.toBuilder() : null;
        }

        public final void setOriginAccessControlList(OriginAccessControlList.BuilderImpl originAccessControlList) {
            this.originAccessControlList = originAccessControlList != null ? originAccessControlList.build() : null;
        }

        @Override
        public final Builder originAccessControlList(OriginAccessControlList originAccessControlList) {
            this.originAccessControlList = originAccessControlList;
            return this;
        }

        @Override
        public ListOriginAccessControlsResponse build() {
            return new ListOriginAccessControlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOriginAccessControlsResponse> {
        public Builder originAccessControlList(OriginAccessControlList var1);

        default public Builder originAccessControlList(Consumer<OriginAccessControlList.Builder> originAccessControlList) {
            return this.originAccessControlList((OriginAccessControlList)((OriginAccessControlList.Builder)OriginAccessControlList.builder().applyMutation(originAccessControlList)).build());
        }
    }
}

