/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.ImportSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyValueStoreRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateKeyValueStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateKeyValueStoreRequest.getter(CreateKeyValueStoreRequest::name)).setter(CreateKeyValueStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(CreateKeyValueStoreRequest.getter(CreateKeyValueStoreRequest::comment)).setter(CreateKeyValueStoreRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<ImportSource> IMPORT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportSource").getter(CreateKeyValueStoreRequest.getter(CreateKeyValueStoreRequest::importSource)).setter(CreateKeyValueStoreRequest.setter(Builder::importSource)).constructor(ImportSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSource").unmarshallLocationName("ImportSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COMMENT_FIELD, IMPORT_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Comment", COMMENT_FIELD);
            this.put("ImportSource", IMPORT_SOURCE_FIELD);
        }
    });
    private final String name;
    private final String comment;
    private final ImportSource importSource;

    private CreateKeyValueStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.comment = builder.comment;
        this.importSource = builder.importSource;
    }

    public final String name() {
        return this.name;
    }

    public final String comment() {
        return this.comment;
    }

    public final ImportSource importSource() {
        return this.importSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.importSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyValueStoreRequest)) {
            return false;
        }
        CreateKeyValueStoreRequest other = (CreateKeyValueStoreRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.importSource(), other.importSource());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeyValueStoreRequest").add("Name", (Object)this.name()).add("Comment", (Object)this.comment()).add("ImportSource", (Object)this.importSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "ImportSource": {
                return Optional.ofNullable(clazz.cast(this.importSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyValueStoreRequest, T> g) {
        return obj -> g.apply((CreateKeyValueStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String name;
        private String comment;
        private ImportSource importSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyValueStoreRequest model) {
            super(model);
            this.name(model.name);
            this.comment(model.comment);
            this.importSource(model.importSource);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final ImportSource.Builder getImportSource() {
            return this.importSource != null ? this.importSource.toBuilder() : null;
        }

        public final void setImportSource(ImportSource.BuilderImpl importSource) {
            this.importSource = importSource != null ? importSource.build() : null;
        }

        @Override
        public final Builder importSource(ImportSource importSource) {
            this.importSource = importSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeyValueStoreRequest build() {
            return new CreateKeyValueStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyValueStoreRequest> {
        public Builder name(String var1);

        public Builder comment(String var1);

        public Builder importSource(ImportSource var1);

        default public Builder importSource(Consumer<ImportSource.Builder> importSource) {
            return this.importSource((ImportSource)((ImportSource.Builder)ImportSource.builder().applyMutation(importSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

