/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;

public class ListInvalidationsPublisher
implements SdkPublisher<ListInvalidationsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListInvalidationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvalidationsPublisher(CloudFrontAsyncClient client, ListInvalidationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvalidationsPublisher(CloudFrontAsyncClient client, ListInvalidationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvalidationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvalidationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InvalidationSummary> items() {
        Function<ListInvalidationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invalidationList() != null && response.invalidationList().items() != null) {
                return response.invalidationList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInvalidationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInvalidationsResponseFetcher
    implements AsyncPageFetcher<ListInvalidationsResponse> {
        private ListInvalidationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvalidationsResponse previousPage) {
            return previousPage.invalidationList().isTruncated() != null && previousPage.invalidationList().isTruncated() != false;
        }

        public CompletableFuture<ListInvalidationsResponse> nextPage(ListInvalidationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvalidationsPublisher.this.client.listInvalidations(ListInvalidationsPublisher.this.firstRequest);
            }
            return ListInvalidationsPublisher.this.client.listInvalidations((ListInvalidationsRequest)((Object)ListInvalidationsPublisher.this.firstRequest.toBuilder().marker(previousPage.invalidationList().nextMarker()).build()));
        }
    }
}

