/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the information for a CloudFront streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingDistributionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingDistributionSummary.Builder, StreamingDistributionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(StreamingDistributionSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ARN")
            .getter(getter(StreamingDistributionSummary::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(StreamingDistributionSummary::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(StreamingDistributionSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DomainName")
            .getter(getter(StreamingDistributionSummary::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName")
                    .unmarshallLocationName("DomainName").build()).build();

    private static final SdkField<S3Origin> S3_ORIGIN_FIELD = SdkField
            .<S3Origin> builder(MarshallingType.SDK_POJO)
            .memberName("S3Origin")
            .getter(getter(StreamingDistributionSummary::s3Origin))
            .setter(setter(Builder::s3Origin))
            .constructor(S3Origin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Origin")
                    .unmarshallLocationName("S3Origin").build()).build();

    private static final SdkField<Aliases> ALIASES_FIELD = SdkField
            .<Aliases> builder(MarshallingType.SDK_POJO)
            .memberName("Aliases")
            .getter(getter(StreamingDistributionSummary::aliases))
            .setter(setter(Builder::aliases))
            .constructor(Aliases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases")
                    .unmarshallLocationName("Aliases").build()).build();

    private static final SdkField<TrustedSigners> TRUSTED_SIGNERS_FIELD = SdkField
            .<TrustedSigners> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedSigners")
            .getter(getter(StreamingDistributionSummary::trustedSigners))
            .setter(setter(Builder::trustedSigners))
            .constructor(TrustedSigners::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedSigners")
                    .unmarshallLocationName("TrustedSigners").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(StreamingDistributionSummary::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<String> PRICE_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PriceClass")
            .getter(getter(StreamingDistributionSummary::priceClassAsString))
            .setter(setter(Builder::priceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceClass")
                    .unmarshallLocationName("PriceClass").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(StreamingDistributionSummary::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, DOMAIN_NAME_FIELD, S3_ORIGIN_FIELD, ALIASES_FIELD, TRUSTED_SIGNERS_FIELD,
            COMMENT_FIELD, PRICE_CLASS_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final S3Origin s3Origin;

    private final Aliases aliases;

    private final TrustedSigners trustedSigners;

    private final String comment;

    private final String priceClass;

    private final Boolean enabled;

    private StreamingDistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.trustedSigners = builder.trustedSigners;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the streaming distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
     * <code>123456789012</code> is your Amazon Web Services account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the streaming distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your Amazon Web Services account ID.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates the current status of the distribution. When the status is <code>Deployed</code>, the distribution's
     * information is fully propagated throughout the Amazon CloudFront system.
     * </p>
     * 
     * @return Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
     *         distribution's information is fully propagated throughout the Amazon CloudFront system.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the distribution was last modified.
     * </p>
     * 
     * @return The date and time the distribution was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name corresponding to the distribution, for example,
     *         <code>d111111abcdef8.cloudfront.net</code>.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your
     * media files for distribution.
     * </p>
     * 
     * @return A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
     *         your media files for distribution.
     */
    public final S3Origin s3Origin() {
        return s3Origin;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
     * distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         streaming distribution.
     */
    public final Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to create signed
     * URLs for private content. If you want to require signed URLs in requests for objects in the target origin that
     * match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>,
     * and specify the applicable values for <code>Quantity</code> and <code>Items</code>.If you don't want to require
     * signed URLs in requests for objects that match <code>PathPattern</code>, specify <code>false</code> for
     * <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change, or
     * remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if it's currently
     * <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted signers that you
     * want to include in the updated distribution.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to create
     *         signed URLs for private content. If you want to require signed URLs in requests for objects in the target
     *         origin that match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for
     *         <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and <code>Items</code>
     *         .If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>,
     *         specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
     *         <code>Items</code>. To add, change, or remove one or more trusted signers, change <code>Enabled</code> to
     *         <code>true</code> (if it's currently <code>false</code>), change <code>Quantity</code> as applicable, and
     *         specify all of the trusted signers that you want to include in the updated distribution.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * The comment originally specified when this distribution was created.
     * </p>
     * 
     * @return The comment originally specified when this distribution was created.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public final PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public final String priceClassAsString() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the distribution is enabled to accept end user requests for content.
     * </p>
     * 
     * @return Whether the distribution is enabled to accept end user requests for content.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Origin());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionSummary)) {
            return false;
        }
        StreamingDistributionSummary other = (StreamingDistributionSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(s3Origin(), other.s3Origin())
                && Objects.equals(aliases(), other.aliases()) && Objects.equals(trustedSigners(), other.trustedSigners())
                && Objects.equals(comment(), other.comment()) && Objects.equals(priceClassAsString(), other.priceClassAsString())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingDistributionSummary").add("Id", id()).add("ARN", arn()).add("Status", status())
                .add("LastModifiedTime", lastModifiedTime()).add("DomainName", domainName()).add("S3Origin", s3Origin())
                .add("Aliases", aliases()).add("TrustedSigners", trustedSigners()).add("Comment", comment())
                .add("PriceClass", priceClassAsString()).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "S3Origin":
            return Optional.ofNullable(clazz.cast(s3Origin()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        case "TrustedSigners":
            return Optional.ofNullable(clazz.cast(trustedSigners()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "PriceClass":
            return Optional.ofNullable(clazz.cast(priceClassAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingDistributionSummary, T> g) {
        return obj -> g.apply((StreamingDistributionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingDistributionSummary> {
        /**
         * <p>
         * The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the streaming distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
         * <code>123456789012</code> is your Amazon Web Services account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the streaming distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
         * distribution's information is fully propagated throughout the Amazon CloudFront system.
         * </p>
         * 
         * @param status
         *        Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
         *        distribution's information is fully propagated throughout the Amazon CloudFront system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name corresponding to the distribution, for example,
         *        <code>d111111abcdef8.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * 
         * @param s3Origin
         *        A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to
         *        get your media files for distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Origin(S3Origin s3Origin);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Origin.Builder} avoiding the need to create
         * one manually via {@link S3Origin#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Origin.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Origin(S3Origin)}.
         * 
         * @param s3Origin
         *        a consumer that will call methods on {@link S3Origin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Origin(S3Origin)
         */
        default Builder s3Origin(Consumer<S3Origin.Builder> s3Origin) {
            return s3Origin(S3Origin.builder().applyMutation(s3Origin).build());
        }

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Aliases.Builder} avoiding the need to create one
         * manually via {@link Aliases#builder()}.
         *
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().applyMutation(aliases).build());
        }

        /**
         * <p>
         * A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to create
         * signed URLs for private content. If you want to require signed URLs in requests for objects in the target
         * origin that match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for
         * <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and <code>Items</code>.If
         * you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify
         * <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
         * <code>Items</code>. To add, change, or remove one or more trusted signers, change <code>Enabled</code> to
         * <code>true</code> (if it's currently <code>false</code>), change <code>Quantity</code> as applicable, and
         * specify all of the trusted signers that you want to include in the updated distribution.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to
         *        create signed URLs for private content. If you want to require signed URLs in requests for objects in
         *        the target origin that match the <code>PathPattern</code> for this cache behavior, specify
         *        <code>true</code> for <code>Enabled</code>, and specify the applicable values for
         *        <code>Quantity</code> and <code>Items</code>.If you don't want to require signed URLs in requests for
         *        objects that match <code>PathPattern</code>, specify <code>false</code> for <code>Enabled</code> and
         *        <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change, or remove one or
         *        more trusted signers, change <code>Enabled</code> to <code>true</code> (if it's currently
         *        <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted
         *        signers that you want to include in the updated distribution.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to create
         * signed URLs for private content. If you want to require signed URLs in requests for objects in the target
         * origin that match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for
         * <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and <code>Items</code>.If
         * you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify
         * <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
         * <code>Items</code>. To add, change, or remove one or more trusted signers, change <code>Enabled</code> to
         * <code>true</code> (if it's currently <code>false</code>), change <code>Quantity</code> as applicable, and
         * specify all of the trusted signers that you want to include in the updated distribution.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedSigners.Builder} avoiding the need to
         * create one manually via {@link TrustedSigners#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedSigners.Builder#build()} is called immediately and its
         * result is passed to {@link #trustedSigners(TrustedSigners)}.
         * 
         * @param trustedSigners
         *        a consumer that will call methods on {@link TrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedSigners(TrustedSigners)
         */
        default Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return trustedSigners(TrustedSigners.builder().applyMutation(trustedSigners).build());
        }

        /**
         * <p>
         * The comment originally specified when this distribution was created.
         * </p>
         * 
         * @param comment
         *        The comment originally specified when this distribution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the distribution is enabled to accept end user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the distribution is enabled to accept end user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private S3Origin s3Origin;

        private Aliases aliases;

        private TrustedSigners trustedSigners;

        private String comment;

        private String priceClass;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionSummary model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            domainName(model.domainName);
            s3Origin(model.s3Origin);
            aliases(model.aliases);
            trustedSigners(model.trustedSigners);
            comment(model.comment);
            priceClass(model.priceClass);
            enabled(model.enabled);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final S3Origin.Builder getS3Origin() {
            return s3Origin != null ? s3Origin.toBuilder() : null;
        }

        public final void setS3Origin(S3Origin.BuilderImpl s3Origin) {
            this.s3Origin = s3Origin != null ? s3Origin.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        @Override
        @Transient
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return trustedSigners != null ? trustedSigners.toBuilder() : null;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        @Override
        @Transient
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        @Transient
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        @Override
        @Transient
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        @Transient
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass == null ? null : priceClass.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public StreamingDistributionSummary build() {
            return new StreamingDistributionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
