/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An HTTP response header name and its value. CloudFront includes this header in HTTP responses that it sends for
 * requests that match a cache behavior that’s associated with this response headers policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicyCustomHeader implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicyCustomHeader.Builder, ResponseHeadersPolicyCustomHeader> {
    private static final SdkField<String> HEADER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Header")
            .getter(getter(ResponseHeadersPolicyCustomHeader::header))
            .setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header")
                    .unmarshallLocationName("Header").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Value")
            .getter(getter(ResponseHeadersPolicyCustomHeader::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("Value").build()).build();

    private static final SdkField<Boolean> OVERRIDE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Override")
            .getter(getter(ResponseHeadersPolicyCustomHeader::override))
            .setter(setter(Builder::override))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Override")
                    .unmarshallLocationName("Override").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD, VALUE_FIELD,
            OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String header;

    private final String value;

    private final Boolean override;

    private ResponseHeadersPolicyCustomHeader(BuilderImpl builder) {
        this.header = builder.header;
        this.value = builder.value;
        this.override = builder.override;
    }

    /**
     * <p>
     * The HTTP response header name.
     * </p>
     * 
     * @return The HTTP response header name.
     */
    public final String header() {
        return header;
    }

    /**
     * <p>
     * The value for the HTTP response header.
     * </p>
     * 
     * @return The value for the HTTP response header.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * A Boolean that determines whether CloudFront overrides a response header with the same name received from the
     * origin with the header specified here.
     * </p>
     * 
     * @return A Boolean that determines whether CloudFront overrides a response header with the same name received from
     *         the origin with the header specified here.
     */
    public final Boolean override() {
        return override;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(override());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyCustomHeader)) {
            return false;
        }
        ResponseHeadersPolicyCustomHeader other = (ResponseHeadersPolicyCustomHeader) obj;
        return Objects.equals(header(), other.header()) && Objects.equals(value(), other.value())
                && Objects.equals(override(), other.override());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicyCustomHeader").add("Header", header()).add("Value", value())
                .add("Override", override()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Override":
            return Optional.ofNullable(clazz.cast(override()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyCustomHeader, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyCustomHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicyCustomHeader> {
        /**
         * <p>
         * The HTTP response header name.
         * </p>
         * 
         * @param header
         *        The HTTP response header name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(String header);

        /**
         * <p>
         * The value for the HTTP response header.
         * </p>
         * 
         * @param value
         *        The value for the HTTP response header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * A Boolean that determines whether CloudFront overrides a response header with the same name received from the
         * origin with the header specified here.
         * </p>
         * 
         * @param override
         *        A Boolean that determines whether CloudFront overrides a response header with the same name received
         *        from the origin with the header specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder override(Boolean override);
    }

    static final class BuilderImpl implements Builder {
        private String header;

        private String value;

        private Boolean override;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyCustomHeader model) {
            header(model.header);
            value(model.value);
            override(model.override);
        }

        public final String getHeader() {
            return header;
        }

        public final void setHeader(String header) {
            this.header = header;
        }

        @Override
        @Transient
        public final Builder header(String header) {
            this.header = header;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getOverride() {
            return override;
        }

        public final void setOverride(Boolean override) {
            this.override = override;
        }

        @Override
        @Transient
        public final Builder override(Boolean override) {
            this.override = override;
            return this;
        }

        @Override
        public ResponseHeadersPolicyCustomHeader build() {
            return new ResponseHeadersPolicyCustomHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
