/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An invalidation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Invalidation implements SdkPojo, Serializable, ToCopyableBuilder<Invalidation.Builder, Invalidation> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(Invalidation::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(Invalidation::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(Invalidation::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("CreateTime").build()).build();

    private static final SdkField<InvalidationBatch> INVALIDATION_BATCH_FIELD = SdkField
            .<InvalidationBatch> builder(MarshallingType.SDK_POJO)
            .memberName("InvalidationBatch")
            .getter(getter(Invalidation::invalidationBatch))
            .setter(setter(Builder::invalidationBatch))
            .constructor(InvalidationBatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidationBatch")
                    .unmarshallLocationName("InvalidationBatch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD,
            CREATE_TIME_FIELD, INVALIDATION_BATCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String status;

    private final Instant createTime;

    private final InvalidationBatch invalidationBatch;

    private Invalidation(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.invalidationBatch = builder.invalidationBatch;
    }

    /**
     * <p>
     * The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the invalidation request. When the invalidation batch is finished, the status is
     * <code>Completed</code>.
     * </p>
     * 
     * @return The status of the invalidation request. When the invalidation batch is finished, the status is
     *         <code>Completed</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the invalidation request was first made.
     * </p>
     * 
     * @return The date and time the invalidation request was first made.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The current invalidation information for the batch request.
     * </p>
     * 
     * @return The current invalidation information for the batch request.
     */
    public final InvalidationBatch invalidationBatch() {
        return invalidationBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(invalidationBatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invalidation)) {
            return false;
        }
        Invalidation other = (Invalidation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(status(), other.status())
                && Objects.equals(createTime(), other.createTime())
                && Objects.equals(invalidationBatch(), other.invalidationBatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Invalidation").add("Id", id()).add("Status", status()).add("CreateTime", createTime())
                .add("InvalidationBatch", invalidationBatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "InvalidationBatch":
            return Optional.ofNullable(clazz.cast(invalidationBatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Invalidation, T> g) {
        return obj -> g.apply((Invalidation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Invalidation> {
        /**
         * <p>
         * The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the invalidation request. When the invalidation batch is finished, the status is
         * <code>Completed</code>.
         * </p>
         * 
         * @param status
         *        The status of the invalidation request. When the invalidation batch is finished, the status is
         *        <code>Completed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the invalidation request was first made.
         * </p>
         * 
         * @param createTime
         *        The date and time the invalidation request was first made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The current invalidation information for the batch request.
         * </p>
         * 
         * @param invalidationBatch
         *        The current invalidation information for the batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationBatch(InvalidationBatch invalidationBatch);

        /**
         * <p>
         * The current invalidation information for the batch request.
         * </p>
         * This is a convenience that creates an instance of the {@link InvalidationBatch.Builder} avoiding the need to
         * create one manually via {@link InvalidationBatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link InvalidationBatch.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidationBatch(InvalidationBatch)}.
         * 
         * @param invalidationBatch
         *        a consumer that will call methods on {@link InvalidationBatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidationBatch(InvalidationBatch)
         */
        default Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return invalidationBatch(InvalidationBatch.builder().applyMutation(invalidationBatch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant createTime;

        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(Invalidation model) {
            id(model.id);
            status(model.status);
            createTime(model.createTime);
            invalidationBatch(model.invalidationBatch);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return invalidationBatch != null ? invalidationBatch.toBuilder() : null;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        @Override
        @Transient
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        @Override
        public Invalidation build() {
            return new Invalidation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
