/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information and metadata about a CloudFront function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionSummary implements SdkPojo, Serializable, ToCopyableBuilder<FunctionSummary.Builder, FunctionSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(FunctionSummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(FunctionSummary::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<FunctionConfig> FUNCTION_CONFIG_FIELD = SdkField
            .<FunctionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("FunctionConfig")
            .getter(getter(FunctionSummary::functionConfig))
            .setter(setter(Builder::functionConfig))
            .constructor(FunctionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionConfig")
                    .unmarshallLocationName("FunctionConfig").build()).build();

    private static final SdkField<FunctionMetadata> FUNCTION_METADATA_FIELD = SdkField
            .<FunctionMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("FunctionMetadata")
            .getter(getter(FunctionSummary::functionMetadata))
            .setter(setter(Builder::functionMetadata))
            .constructor(FunctionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionMetadata")
                    .unmarshallLocationName("FunctionMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            FUNCTION_CONFIG_FIELD, FUNCTION_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final FunctionConfig functionConfig;

    private final FunctionMetadata functionMetadata;

    private FunctionSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.functionConfig = builder.functionConfig;
        this.functionMetadata = builder.functionMetadata;
    }

    /**
     * <p>
     * The name of the CloudFront function.
     * </p>
     * 
     * @return The name of the CloudFront function.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the CloudFront function.
     * </p>
     * 
     * @return The status of the CloudFront function.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Contains configuration information about a CloudFront function.
     * </p>
     * 
     * @return Contains configuration information about a CloudFront function.
     */
    public final FunctionConfig functionConfig() {
        return functionConfig;
    }

    /**
     * <p>
     * Contains metadata about a CloudFront function.
     * </p>
     * 
     * @return Contains metadata about a CloudFront function.
     */
    public final FunctionMetadata functionMetadata() {
        return functionMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(functionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(functionMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionSummary)) {
            return false;
        }
        FunctionSummary other = (FunctionSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(status(), other.status())
                && Objects.equals(functionConfig(), other.functionConfig())
                && Objects.equals(functionMetadata(), other.functionMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionSummary").add("Name", name()).add("Status", status())
                .add("FunctionConfig", functionConfig()).add("FunctionMetadata", functionMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FunctionConfig":
            return Optional.ofNullable(clazz.cast(functionConfig()));
        case "FunctionMetadata":
            return Optional.ofNullable(clazz.cast(functionMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionSummary, T> g) {
        return obj -> g.apply((FunctionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionSummary> {
        /**
         * <p>
         * The name of the CloudFront function.
         * </p>
         * 
         * @param name
         *        The name of the CloudFront function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the CloudFront function.
         * </p>
         * 
         * @param status
         *        The status of the CloudFront function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Contains configuration information about a CloudFront function.
         * </p>
         * 
         * @param functionConfig
         *        Contains configuration information about a CloudFront function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionConfig(FunctionConfig functionConfig);

        /**
         * <p>
         * Contains configuration information about a CloudFront function.
         * </p>
         * This is a convenience that creates an instance of the {@link FunctionConfig.Builder} avoiding the need to
         * create one manually via {@link FunctionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #functionConfig(FunctionConfig)}.
         * 
         * @param functionConfig
         *        a consumer that will call methods on {@link FunctionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionConfig(FunctionConfig)
         */
        default Builder functionConfig(Consumer<FunctionConfig.Builder> functionConfig) {
            return functionConfig(FunctionConfig.builder().applyMutation(functionConfig).build());
        }

        /**
         * <p>
         * Contains metadata about a CloudFront function.
         * </p>
         * 
         * @param functionMetadata
         *        Contains metadata about a CloudFront function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionMetadata(FunctionMetadata functionMetadata);

        /**
         * <p>
         * Contains metadata about a CloudFront function.
         * </p>
         * This is a convenience that creates an instance of the {@link FunctionMetadata.Builder} avoiding the need to
         * create one manually via {@link FunctionMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #functionMetadata(FunctionMetadata)}.
         * 
         * @param functionMetadata
         *        a consumer that will call methods on {@link FunctionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionMetadata(FunctionMetadata)
         */
        default Builder functionMetadata(Consumer<FunctionMetadata.Builder> functionMetadata) {
            return functionMetadata(FunctionMetadata.builder().applyMutation(functionMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private FunctionConfig functionConfig;

        private FunctionMetadata functionMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionSummary model) {
            name(model.name);
            status(model.status);
            functionConfig(model.functionConfig);
            functionMetadata(model.functionMetadata);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final FunctionConfig.Builder getFunctionConfig() {
            return functionConfig != null ? functionConfig.toBuilder() : null;
        }

        public final void setFunctionConfig(FunctionConfig.BuilderImpl functionConfig) {
            this.functionConfig = functionConfig != null ? functionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder functionConfig(FunctionConfig functionConfig) {
            this.functionConfig = functionConfig;
            return this;
        }

        public final FunctionMetadata.Builder getFunctionMetadata() {
            return functionMetadata != null ? functionMetadata.toBuilder() : null;
        }

        public final void setFunctionMetadata(FunctionMetadata.BuilderImpl functionMetadata) {
            this.functionMetadata = functionMetadata != null ? functionMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder functionMetadata(FunctionMetadata functionMetadata) {
            this.functionMetadata = functionMetadata;
            return this;
        }

        @Override
        public FunctionSummary build() {
            return new FunctionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
