/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRealtimeLogConfigsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListRealtimeLogConfigsResponse> {
    private static final SdkField<RealtimeLogConfigs> REALTIME_LOG_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RealtimeLogConfigs").getter(ListRealtimeLogConfigsResponse.getter(ListRealtimeLogConfigsResponse::realtimeLogConfigs)).setter(ListRealtimeLogConfigsResponse.setter(Builder::realtimeLogConfigs)).constructor(RealtimeLogConfigs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigs").unmarshallLocationName("RealtimeLogConfigs").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REALTIME_LOG_CONFIGS_FIELD));
    private final RealtimeLogConfigs realtimeLogConfigs;

    private ListRealtimeLogConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.realtimeLogConfigs = builder.realtimeLogConfigs;
    }

    public RealtimeLogConfigs realtimeLogConfigs() {
        return this.realtimeLogConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.realtimeLogConfigs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRealtimeLogConfigsResponse)) {
            return false;
        }
        ListRealtimeLogConfigsResponse other = (ListRealtimeLogConfigsResponse)((Object)obj);
        return Objects.equals(this.realtimeLogConfigs(), other.realtimeLogConfigs());
    }

    public String toString() {
        return ToString.builder((String)"ListRealtimeLogConfigsResponse").add("RealtimeLogConfigs", (Object)this.realtimeLogConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RealtimeLogConfigs": {
                return Optional.ofNullable(clazz.cast(this.realtimeLogConfigs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRealtimeLogConfigsResponse, T> g) {
        return obj -> g.apply((ListRealtimeLogConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private RealtimeLogConfigs realtimeLogConfigs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRealtimeLogConfigsResponse model) {
            super(model);
            this.realtimeLogConfigs(model.realtimeLogConfigs);
        }

        public final RealtimeLogConfigs.Builder getRealtimeLogConfigs() {
            return this.realtimeLogConfigs != null ? this.realtimeLogConfigs.toBuilder() : null;
        }

        @Override
        public final Builder realtimeLogConfigs(RealtimeLogConfigs realtimeLogConfigs) {
            this.realtimeLogConfigs = realtimeLogConfigs;
            return this;
        }

        public final void setRealtimeLogConfigs(RealtimeLogConfigs.BuilderImpl realtimeLogConfigs) {
            this.realtimeLogConfigs = realtimeLogConfigs != null ? realtimeLogConfigs.build() : null;
        }

        @Override
        public ListRealtimeLogConfigsResponse build() {
            return new ListRealtimeLogConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRealtimeLogConfigsResponse> {
        public Builder realtimeLogConfigs(RealtimeLogConfigs var1);

        default public Builder realtimeLogConfigs(Consumer<RealtimeLogConfigs.Builder> realtimeLogConfigs) {
            return this.realtimeLogConfigs((RealtimeLogConfigs)((RealtimeLogConfigs.Builder)RealtimeLogConfigs.builder().applyMutation(realtimeLogConfigs)).build());
        }
    }
}

