/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFieldLevelEncryptionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetFieldLevelEncryptionResponse> {
    private static final SdkField<FieldLevelEncryption> FIELD_LEVEL_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldLevelEncryption").getter(GetFieldLevelEncryptionResponse.getter(GetFieldLevelEncryptionResponse::fieldLevelEncryption)).setter(GetFieldLevelEncryptionResponse.setter(Builder::fieldLevelEncryption)).constructor(FieldLevelEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryption").unmarshallLocationName("FieldLevelEncryption").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetFieldLevelEncryptionResponse.getter(GetFieldLevelEncryptionResponse::eTag)).setter(GetFieldLevelEncryptionResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_LEVEL_ENCRYPTION_FIELD, E_TAG_FIELD));
    private final FieldLevelEncryption fieldLevelEncryption;
    private final String eTag;

    private GetFieldLevelEncryptionResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryption = builder.fieldLevelEncryption;
        this.eTag = builder.eTag;
    }

    public FieldLevelEncryption fieldLevelEncryption() {
        return this.fieldLevelEncryption;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLevelEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFieldLevelEncryptionResponse)) {
            return false;
        }
        GetFieldLevelEncryptionResponse other = (GetFieldLevelEncryptionResponse)((Object)obj);
        return Objects.equals(this.fieldLevelEncryption(), other.fieldLevelEncryption()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        return ToString.builder((String)"GetFieldLevelEncryptionResponse").add("FieldLevelEncryption", (Object)this.fieldLevelEncryption()).add("ETag", (Object)this.eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldLevelEncryption": {
                return Optional.ofNullable(clazz.cast(this.fieldLevelEncryption()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFieldLevelEncryptionResponse, T> g) {
        return obj -> g.apply((GetFieldLevelEncryptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private FieldLevelEncryption fieldLevelEncryption;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFieldLevelEncryptionResponse model) {
            super(model);
            this.fieldLevelEncryption(model.fieldLevelEncryption);
            this.eTag(model.eTag);
        }

        public final FieldLevelEncryption.Builder getFieldLevelEncryption() {
            return this.fieldLevelEncryption != null ? this.fieldLevelEncryption.toBuilder() : null;
        }

        @Override
        public final Builder fieldLevelEncryption(FieldLevelEncryption fieldLevelEncryption) {
            this.fieldLevelEncryption = fieldLevelEncryption;
            return this;
        }

        public final void setFieldLevelEncryption(FieldLevelEncryption.BuilderImpl fieldLevelEncryption) {
            this.fieldLevelEncryption = fieldLevelEncryption != null ? fieldLevelEncryption.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetFieldLevelEncryptionResponse build() {
            return new GetFieldLevelEncryptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFieldLevelEncryptionResponse> {
        public Builder fieldLevelEncryption(FieldLevelEncryption var1);

        default public Builder fieldLevelEncryption(Consumer<FieldLevelEncryption.Builder> fieldLevelEncryption) {
            return this.fieldLevelEncryption((FieldLevelEncryption)((FieldLevelEncryption.Builder)FieldLevelEncryption.builder().applyMutation(fieldLevelEncryption)).build());
        }

        public Builder eTag(String var1);
    }
}

