/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyQueryStringBehavior;
import software.amazon.awssdk.services.cloudfront.model.QueryStringNames;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginRequestPolicyQueryStringsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginRequestPolicyQueryStringsConfig> {
    private static final SdkField<String> QUERY_STRING_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginRequestPolicyQueryStringsConfig.getter(OriginRequestPolicyQueryStringsConfig::queryStringBehaviorAsString)).setter(OriginRequestPolicyQueryStringsConfig.setter(Builder::queryStringBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringBehavior").unmarshallLocationName("QueryStringBehavior").build()}).build();
    private static final SdkField<QueryStringNames> QUERY_STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OriginRequestPolicyQueryStringsConfig.getter(OriginRequestPolicyQueryStringsConfig::queryStrings)).setter(OriginRequestPolicyQueryStringsConfig.setter(Builder::queryStrings)).constructor(QueryStringNames::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStrings").unmarshallLocationName("QueryStrings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_BEHAVIOR_FIELD, QUERY_STRINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String queryStringBehavior;
    private final QueryStringNames queryStrings;

    private OriginRequestPolicyQueryStringsConfig(BuilderImpl builder) {
        this.queryStringBehavior = builder.queryStringBehavior;
        this.queryStrings = builder.queryStrings;
    }

    public OriginRequestPolicyQueryStringBehavior queryStringBehavior() {
        return OriginRequestPolicyQueryStringBehavior.fromValue(this.queryStringBehavior);
    }

    public String queryStringBehaviorAsString() {
        return this.queryStringBehavior;
    }

    public QueryStringNames queryStrings() {
        return this.queryStrings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStringBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginRequestPolicyQueryStringsConfig)) {
            return false;
        }
        OriginRequestPolicyQueryStringsConfig other = (OriginRequestPolicyQueryStringsConfig)obj;
        return Objects.equals(this.queryStringBehaviorAsString(), other.queryStringBehaviorAsString()) && Objects.equals(this.queryStrings(), other.queryStrings());
    }

    public String toString() {
        return ToString.builder((String)"OriginRequestPolicyQueryStringsConfig").add("QueryStringBehavior", (Object)this.queryStringBehaviorAsString()).add("QueryStrings", (Object)this.queryStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryStringBehavior": {
                return Optional.ofNullable(clazz.cast(this.queryStringBehaviorAsString()));
            }
            case "QueryStrings": {
                return Optional.ofNullable(clazz.cast(this.queryStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginRequestPolicyQueryStringsConfig, T> g) {
        return obj -> g.apply((OriginRequestPolicyQueryStringsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryStringBehavior;
        private QueryStringNames queryStrings;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginRequestPolicyQueryStringsConfig model) {
            this.queryStringBehavior(model.queryStringBehavior);
            this.queryStrings(model.queryStrings);
        }

        public final String getQueryStringBehavior() {
            return this.queryStringBehavior;
        }

        @Override
        public final Builder queryStringBehavior(String queryStringBehavior) {
            this.queryStringBehavior = queryStringBehavior;
            return this;
        }

        @Override
        public final Builder queryStringBehavior(OriginRequestPolicyQueryStringBehavior queryStringBehavior) {
            this.queryStringBehavior(queryStringBehavior == null ? null : queryStringBehavior.toString());
            return this;
        }

        public final void setQueryStringBehavior(String queryStringBehavior) {
            this.queryStringBehavior = queryStringBehavior;
        }

        public final QueryStringNames.Builder getQueryStrings() {
            return this.queryStrings != null ? this.queryStrings.toBuilder() : null;
        }

        @Override
        public final Builder queryStrings(QueryStringNames queryStrings) {
            this.queryStrings = queryStrings;
            return this;
        }

        public final void setQueryStrings(QueryStringNames.BuilderImpl queryStrings) {
            this.queryStrings = queryStrings != null ? queryStrings.build() : null;
        }

        public OriginRequestPolicyQueryStringsConfig build() {
            return new OriginRequestPolicyQueryStringsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginRequestPolicyQueryStringsConfig> {
        public Builder queryStringBehavior(String var1);

        public Builder queryStringBehavior(OriginRequestPolicyQueryStringBehavior var1);

        public Builder queryStrings(QueryStringNames var1);

        default public Builder queryStrings(Consumer<QueryStringNames.Builder> queryStrings) {
            return this.queryStrings((QueryStringNames)((QueryStringNames.Builder)QueryStringNames.builder().applyMutation(queryStrings)).build());
        }
    }
}

