/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media
 * files for distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Origin implements SdkPojo, Serializable, ToCopyableBuilder<S3Origin.Builder, S3Origin> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(S3Origin::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName")
                    .unmarshallLocationName("DomainName").build()).build();

    private static final SdkField<String> ORIGIN_ACCESS_IDENTITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(S3Origin::originAccessIdentity))
            .setter(setter(Builder::originAccessIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessIdentity")
                    .unmarshallLocationName("OriginAccessIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ORIGIN_ACCESS_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String originAccessIdentity;

    private S3Origin(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.originAccessIdentity = builder.originAccessIdentity;
    }

    /**
     * <p>
     * The DNS name of the Amazon S3 origin.
     * </p>
     * 
     * @return The DNS name of the Amazon S3 origin.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The CloudFront origin access identity to associate with the distribution. Use an origin access identity to
     * configure the distribution so that end users can only access objects in an Amazon S3 bucket through CloudFront.
     * </p>
     * <p>
     * If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify
     * an empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To delete the origin access identity from an existing distribution, update the distribution configuration and
     * include an empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To replace the origin access identity, update the distribution configuration and specify the new origin access
     * identity.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     * >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i> Amazon CloudFront
     * Developer Guide</i>.
     * </p>
     * 
     * @return The CloudFront origin access identity to associate with the distribution. Use an origin access identity
     *         to configure the distribution so that end users can only access objects in an Amazon S3 bucket through
     *         CloudFront.</p>
     *         <p>
     *         If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
     *         specify an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To delete the origin access identity from an existing distribution, update the distribution configuration
     *         and include an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To replace the origin access identity, update the distribution configuration and specify the new origin
     *         access identity.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *         >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i> Amazon
     *         CloudFront Developer Guide</i>.
     */
    public String originAccessIdentity() {
        return originAccessIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(originAccessIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Origin)) {
            return false;
        }
        S3Origin other = (S3Origin) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(originAccessIdentity(), other.originAccessIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3Origin").add("DomainName", domainName()).add("OriginAccessIdentity", originAccessIdentity())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "OriginAccessIdentity":
            return Optional.ofNullable(clazz.cast(originAccessIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Origin, T> g) {
        return obj -> g.apply((S3Origin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Origin> {
        /**
         * <p>
         * The DNS name of the Amazon S3 origin.
         * </p>
         * 
         * @param domainName
         *        The DNS name of the Amazon S3 origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The CloudFront origin access identity to associate with the distribution. Use an origin access identity to
         * configure the distribution so that end users can only access objects in an Amazon S3 bucket through
         * CloudFront.
         * </p>
         * <p>
         * If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
         * specify an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To delete the origin access identity from an existing distribution, update the distribution configuration and
         * include an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To replace the origin access identity, update the distribution configuration and specify the new origin
         * access identity.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
         * >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i> Amazon
         * CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param originAccessIdentity
         *        The CloudFront origin access identity to associate with the distribution. Use an origin access
         *        identity to configure the distribution so that end users can only access objects in an Amazon S3
         *        bucket through CloudFront.</p>
         *        <p>
         *        If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3
         *        URL, specify an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To delete the origin access identity from an existing distribution, update the distribution
         *        configuration and include an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To replace the origin access identity, update the distribution configuration and specify the new
         *        origin access identity.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
         *        >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i> Amazon
         *        CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccessIdentity(String originAccessIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String originAccessIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Origin model) {
            domainName(model.domainName);
            originAccessIdentity(model.originAccessIdentity);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOriginAccessIdentity() {
            return originAccessIdentity;
        }

        @Override
        public final Builder originAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        public final void setOriginAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
        }

        @Override
        public S3Origin build() {
            return new S3Origin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
