/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFieldLevelEncryptionProfilesResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListFieldLevelEncryptionProfilesResponse.Builder, ListFieldLevelEncryptionProfilesResponse> {
    private static final SdkField<FieldLevelEncryptionProfileList> FIELD_LEVEL_ENCRYPTION_PROFILE_LIST_FIELD = SdkField
            .<FieldLevelEncryptionProfileList> builder(MarshallingType.SDK_POJO)
            .getter(getter(ListFieldLevelEncryptionProfilesResponse::fieldLevelEncryptionProfileList))
            .setter(setter(Builder::fieldLevelEncryptionProfileList))
            .constructor(FieldLevelEncryptionProfileList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionProfileList")
                    .unmarshallLocationName("FieldLevelEncryptionProfileList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIELD_LEVEL_ENCRYPTION_PROFILE_LIST_FIELD));

    private final FieldLevelEncryptionProfileList fieldLevelEncryptionProfileList;

    private ListFieldLevelEncryptionProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryptionProfileList = builder.fieldLevelEncryptionProfileList;
    }

    /**
     * <p>
     * Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     * 
     * @return Returns a list of the field-level encryption profiles that have been created in CloudFront for this
     *         account.
     */
    public FieldLevelEncryptionProfileList fieldLevelEncryptionProfileList() {
        return fieldLevelEncryptionProfileList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionProfileList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFieldLevelEncryptionProfilesResponse)) {
            return false;
        }
        ListFieldLevelEncryptionProfilesResponse other = (ListFieldLevelEncryptionProfilesResponse) obj;
        return Objects.equals(fieldLevelEncryptionProfileList(), other.fieldLevelEncryptionProfileList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFieldLevelEncryptionProfilesResponse")
                .add("FieldLevelEncryptionProfileList", fieldLevelEncryptionProfileList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLevelEncryptionProfileList":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionProfileList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFieldLevelEncryptionProfilesResponse, T> g) {
        return obj -> g.apply((ListFieldLevelEncryptionProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFieldLevelEncryptionProfilesResponse> {
        /**
         * <p>
         * Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.
         * </p>
         * 
         * @param fieldLevelEncryptionProfileList
         *        Returns a list of the field-level encryption profiles that have been created in CloudFront for this
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionProfileList(FieldLevelEncryptionProfileList fieldLevelEncryptionProfileList);

        /**
         * <p>
         * Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.
         * </p>
         * This is a convenience that creates an instance of the {@link FieldLevelEncryptionProfileList.Builder}
         * avoiding the need to create one manually via {@link FieldLevelEncryptionProfileList#builder()}.
         *
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionProfileList.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #fieldLevelEncryptionProfileList(FieldLevelEncryptionProfileList)}.
         * 
         * @param fieldLevelEncryptionProfileList
         *        a consumer that will call methods on {@link FieldLevelEncryptionProfileList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionProfileList(FieldLevelEncryptionProfileList)
         */
        default Builder fieldLevelEncryptionProfileList(
                Consumer<FieldLevelEncryptionProfileList.Builder> fieldLevelEncryptionProfileList) {
            return fieldLevelEncryptionProfileList(FieldLevelEncryptionProfileList.builder()
                    .applyMutation(fieldLevelEncryptionProfileList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FieldLevelEncryptionProfileList fieldLevelEncryptionProfileList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFieldLevelEncryptionProfilesResponse model) {
            super(model);
            fieldLevelEncryptionProfileList(model.fieldLevelEncryptionProfileList);
        }

        public final FieldLevelEncryptionProfileList.Builder getFieldLevelEncryptionProfileList() {
            return fieldLevelEncryptionProfileList != null ? fieldLevelEncryptionProfileList.toBuilder() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionProfileList(FieldLevelEncryptionProfileList fieldLevelEncryptionProfileList) {
            this.fieldLevelEncryptionProfileList = fieldLevelEncryptionProfileList;
            return this;
        }

        public final void setFieldLevelEncryptionProfileList(
                FieldLevelEncryptionProfileList.BuilderImpl fieldLevelEncryptionProfileList) {
            this.fieldLevelEncryptionProfileList = fieldLevelEncryptionProfileList != null ? fieldLevelEncryptionProfileList
                    .build() : null;
        }

        @Override
        public ListFieldLevelEncryptionProfilesResponse build() {
            return new ListFieldLevelEncryptionProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
