/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamingDistributionResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateStreamingDistributionResponse.Builder, CreateStreamingDistributionResponse> {
    private static final SdkField<StreamingDistribution> STREAMING_DISTRIBUTION_FIELD = SdkField
            .<StreamingDistribution> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateStreamingDistributionResponse::streamingDistribution))
            .setter(setter(Builder::streamingDistribution))
            .constructor(StreamingDistribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistribution")
                    .unmarshallLocationName("StreamingDistribution").build(), PayloadTrait.create()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingDistributionResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingDistributionResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_DISTRIBUTION_FIELD,
            LOCATION_FIELD, E_TAG_FIELD));

    private final StreamingDistribution streamingDistribution;

    private final String location;

    private final String eTag;

    private CreateStreamingDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistribution = builder.streamingDistribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The streaming distribution's information.
     * </p>
     * 
     * @return The streaming distribution's information.
     */
    public StreamingDistribution streamingDistribution() {
        return streamingDistribution;
    }

    /**
     * <p>
     * The fully qualified URI of the new streaming distribution resource just created. For example:
     * <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
     * </p>
     * 
     * @return The fully qualified URI of the new streaming distribution resource just created. For example:
     *         <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The current version of the streaming distribution created.
     * </p>
     * 
     * @return The current version of the streaming distribution created.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionResponse)) {
            return false;
        }
        CreateStreamingDistributionResponse other = (CreateStreamingDistributionResponse) obj;
        return Objects.equals(streamingDistribution(), other.streamingDistribution())
                && Objects.equals(location(), other.location()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStreamingDistributionResponse").add("StreamingDistribution", streamingDistribution())
                .add("Location", location()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistribution":
            return Optional.ofNullable(clazz.cast(streamingDistribution()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamingDistributionResponse, T> g) {
        return obj -> g.apply((CreateStreamingDistributionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStreamingDistributionResponse> {
        /**
         * <p>
         * The streaming distribution's information.
         * </p>
         * 
         * @param streamingDistribution
         *        The streaming distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistribution(StreamingDistribution streamingDistribution);

        /**
         * <p>
         * The streaming distribution's information.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistribution.Builder} avoiding the need
         * to create one manually via {@link StreamingDistribution#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistribution.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingDistribution(StreamingDistribution)}.
         * 
         * @param streamingDistribution
         *        a consumer that will call methods on {@link StreamingDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistribution(StreamingDistribution)
         */
        default Builder streamingDistribution(Consumer<StreamingDistribution.Builder> streamingDistribution) {
            return streamingDistribution(StreamingDistribution.builder().applyMutation(streamingDistribution).build());
        }

        /**
         * <p>
         * The fully qualified URI of the new streaming distribution resource just created. For example:
         * <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the new streaming distribution resource just created. For example:
         *        <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current version of the streaming distribution created.
         * </p>
         * 
         * @param eTag
         *        The current version of the streaming distribution created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private StreamingDistribution streamingDistribution;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionResponse model) {
            super(model);
            streamingDistribution(model.streamingDistribution);
            location(model.location);
            eTag(model.eTag);
        }

        public final StreamingDistribution.Builder getStreamingDistribution() {
            return streamingDistribution != null ? streamingDistribution.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final void setStreamingDistribution(StreamingDistribution.BuilderImpl streamingDistribution) {
            this.streamingDistribution = streamingDistribution != null ? streamingDistribution.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateStreamingDistributionResponse build() {
            return new CreateStreamingDistributionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
