/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ViewerProtocolPolicy {
    ALLOW_ALL("allow-all"),
    HTTPS_ONLY("https-only"),
    REDIRECT_TO_HTTPS("redirect-to-https"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ViewerProtocolPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ViewerProtocolPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ViewerProtocolPolicy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ViewerProtocolPolicy> knownValues() {
        return Stream.of(ViewerProtocolPolicy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

