/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Origin access identity configuration. Send a <code>GET</code> request to the
 * <code>/<i>CloudFront API version</i>/CloudFront/identity ID/config</code> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFrontOriginAccessIdentityConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFrontOriginAccessIdentityConfig.Builder, CloudFrontOriginAccessIdentityConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CloudFrontOriginAccessIdentityConfig::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CloudFrontOriginAccessIdentityConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD,
            COMMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String callerReference;

    private final String comment;

    private CloudFrontOriginAccessIdentityConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     * </p>
     * <p>
     * If the value of <code>CallerReference</code> is new (regardless of the content of the
     * <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is created.
     * </p>
     * <p>
     * If the <code>CallerReference</code> is a value already sent in a previous identity request, and the content of
     * the <code>CloudFrontOriginAccessIdentityConfig</code> is identical to the original request (ignoring white
     * space), the response includes the same information returned to the original request.
     * </p>
     * <p>
     * If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity, but
     * the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request,
     * CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     * </p>
     * 
     * @return A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
     *         <p>
     *         If the value of <code>CallerReference</code> is new (regardless of the content of the
     *         <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is created.
     *         </p>
     *         <p>
     *         If the <code>CallerReference</code> is a value already sent in a previous identity request, and the
     *         content of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical to the original request
     *         (ignoring white space), the response includes the same information returned to the original request.
     *         </p>
     *         <p>
     *         If the <code>CallerReference</code> is a value you already sent in a previous request to create an
     *         identity, but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the
     *         original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * Any comments you want to include about the origin access identity.
     * </p>
     * 
     * @return Any comments you want to include about the origin access identity.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentityConfig)) {
            return false;
        }
        CloudFrontOriginAccessIdentityConfig other = (CloudFrontOriginAccessIdentityConfig) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloudFrontOriginAccessIdentityConfig").add("CallerReference", callerReference())
                .add("Comment", comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFrontOriginAccessIdentityConfig, T> g) {
        return obj -> g.apply((CloudFrontOriginAccessIdentityConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFrontOriginAccessIdentityConfig> {
        /**
         * <p>
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         * </p>
         * <p>
         * If the value of <code>CallerReference</code> is new (regardless of the content of the
         * <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is created.
         * </p>
         * <p>
         * If the <code>CallerReference</code> is a value already sent in a previous identity request, and the content
         * of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical to the original request (ignoring white
         * space), the response includes the same information returned to the original request.
         * </p>
         * <p>
         * If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity,
         * but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original
         * request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
         * </p>
         * 
         * @param callerReference
         *        A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
         *        <p>
         *        If the value of <code>CallerReference</code> is new (regardless of the content of the
         *        <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is created.
         *        </p>
         *        <p>
         *        If the <code>CallerReference</code> is a value already sent in a previous identity request, and the
         *        content of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical to the original request
         *        (ignoring white space), the response includes the same information returned to the original request.
         *        </p>
         *        <p>
         *        If the <code>CallerReference</code> is a value you already sent in a previous request to create an
         *        identity, but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from
         *        the original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * Any comments you want to include about the origin access identity.
         * </p>
         * 
         * @param comment
         *        Any comments you want to include about the origin access identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentityConfig model) {
            callerReference(model.callerReference);
            comment(model.comment);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public CloudFrontOriginAccessIdentityConfig build() {
            return new CloudFrontOriginAccessIdentityConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
