/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;

public class ListCloudFrontOriginAccessIdentitiesIterable
implements SdkIterable<ListCloudFrontOriginAccessIdentitiesResponse> {
    private final CloudFrontClient client;
    private final ListCloudFrontOriginAccessIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudFrontOriginAccessIdentitiesIterable(CloudFrontClient client, ListCloudFrontOriginAccessIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCloudFrontOriginAccessIdentitiesResponseFetcher();
    }

    public Iterator<ListCloudFrontOriginAccessIdentitiesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<CloudFrontOriginAccessIdentitySummary> items() {
        Function<ListCloudFrontOriginAccessIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudFrontOriginAccessIdentityList() != null && response.cloudFrontOriginAccessIdentityList().items() != null) {
                return response.cloudFrontOriginAccessIdentityList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListCloudFrontOriginAccessIdentitiesIterable resume(ListCloudFrontOriginAccessIdentitiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCloudFrontOriginAccessIdentitiesIterable(this.client, (ListCloudFrontOriginAccessIdentitiesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.cloudFrontOriginAccessIdentityList().nextMarker()).build()));
        }
        return new ListCloudFrontOriginAccessIdentitiesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListCloudFrontOriginAccessIdentitiesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListCloudFrontOriginAccessIdentitiesResponseFetcher
    implements SyncPageFetcher<ListCloudFrontOriginAccessIdentitiesResponse> {
        private ListCloudFrontOriginAccessIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            return previousPage.cloudFrontOriginAccessIdentityList().isTruncated();
        }

        public ListCloudFrontOriginAccessIdentitiesResponse nextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListCloudFrontOriginAccessIdentitiesIterable.this.client.listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesIterable.this.firstRequest);
            }
            return ListCloudFrontOriginAccessIdentitiesIterable.this.client.listCloudFrontOriginAccessIdentities((ListCloudFrontOriginAccessIdentitiesRequest)((Object)ListCloudFrontOriginAccessIdentitiesIterable.this.firstRequest.toBuilder().marker(previousPage.cloudFrontOriginAccessIdentityList().nextMarker()).build()));
        }
    }
}

