/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Paths;

public class PathsUnmarshaller
implements Unmarshaller<Paths, StaxUnmarshallerContext> {
    private static final PathsUnmarshaller INSTANCE = new PathsUnmarshaller();

    public Paths unmarshall(StaxUnmarshallerContext context) throws Exception {
        Paths.Builder paths;
        block6: {
            paths = Paths.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    paths.items(items);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        paths.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("Items/Path", targetDepth)) continue;
                    items.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            paths.items(items);
        }
        return (Paths)paths.build();
    }

    public static PathsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

