/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Invalidation
implements ToCopyableBuilder<Builder, Invalidation> {
    private final String id;
    private final String status;
    private final Instant createTime;
    private final InvalidationBatch invalidationBatch;

    private Invalidation(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.invalidationBatch = builder.invalidationBatch;
    }

    public String id() {
        return this.id;
    }

    public String status() {
        return this.status;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public InvalidationBatch invalidationBatch() {
        return this.invalidationBatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidationBatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invalidation)) {
            return false;
        }
        Invalidation other = (Invalidation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.invalidationBatch(), other.invalidationBatch());
    }

    public String toString() {
        return ToString.builder((String)"Invalidation").add("Id", (Object)this.id()).add("Status", (Object)this.status()).add("CreateTime", (Object)this.createTime()).add("InvalidationBatch", (Object)this.invalidationBatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "CreateTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
            case "InvalidationBatch": {
                return Optional.of(clazz.cast(this.invalidationBatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private Instant createTime;
        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(Invalidation model) {
            this.id(model.id);
            this.status(model.status);
            this.createTime(model.createTime);
            this.invalidationBatch(model.invalidationBatch);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return this.invalidationBatch != null ? this.invalidationBatch.toBuilder() : null;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        public Invalidation build() {
            return new Invalidation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Invalidation> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder createTime(Instant var1);

        public Builder invalidationBatch(InvalidationBatch var1);

        default public Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return this.invalidationBatch((InvalidationBatch)((InvalidationBatch.Builder)InvalidationBatch.builder().apply(invalidationBatch)).build());
        }
    }
}

