/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.HttpVersion;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.Restrictions;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DistributionSummary
implements ToCopyableBuilder<Builder, DistributionSummary> {
    private final String id;
    private final String arn;
    private final String status;
    private final Instant lastModifiedTime;
    private final String domainName;
    private final Aliases aliases;
    private final Origins origins;
    private final DefaultCacheBehavior defaultCacheBehavior;
    private final CacheBehaviors cacheBehaviors;
    private final CustomErrorResponses customErrorResponses;
    private final String comment;
    private final String priceClass;
    private final Boolean enabled;
    private final ViewerCertificate viewerCertificate;
    private final Restrictions restrictions;
    private final String webACLId;
    private final String httpVersion;
    private final Boolean isIPV6Enabled;

    private DistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.aliases = builder.aliases;
        this.origins = builder.origins;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String status() {
        return this.status;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String domainName() {
        return this.domainName;
    }

    public Aliases aliases() {
        return this.aliases;
    }

    public Origins origins() {
        return this.origins;
    }

    public DefaultCacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public CacheBehaviors cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public CustomErrorResponses customErrorResponses() {
        return this.customErrorResponses;
    }

    public String comment() {
        return this.comment;
    }

    public PriceClass priceClass() {
        return PriceClass.fromValue(this.priceClass);
    }

    public String priceClassString() {
        return this.priceClass;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public ViewerCertificate viewerCertificate() {
        return this.viewerCertificate;
    }

    public Restrictions restrictions() {
        return this.restrictions;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public HttpVersion httpVersion() {
        return HttpVersion.fromValue(this.httpVersion);
    }

    public String httpVersionString() {
        return this.httpVersion;
    }

    public Boolean isIPV6Enabled() {
        return this.isIPV6Enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.origins());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceClassString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpVersionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isIPV6Enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionSummary)) {
            return false;
        }
        DistributionSummary other = (DistributionSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.customErrorResponses(), other.customErrorResponses()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.priceClassString(), other.priceClassString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.viewerCertificate(), other.viewerCertificate()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.httpVersionString(), other.httpVersionString()) && Objects.equals(this.isIPV6Enabled(), other.isIPV6Enabled());
    }

    public String toString() {
        return ToString.builder((String)"DistributionSummary").add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Status", (Object)this.status()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DomainName", (Object)this.domainName()).add("Aliases", (Object)this.aliases()).add("Origins", (Object)this.origins()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviors", (Object)this.cacheBehaviors()).add("CustomErrorResponses", (Object)this.customErrorResponses()).add("Comment", (Object)this.comment()).add("PriceClass", (Object)this.priceClassString()).add("Enabled", (Object)this.enabled()).add("ViewerCertificate", (Object)this.viewerCertificate()).add("Restrictions", (Object)this.restrictions()).add("WebACLId", (Object)this.webACLId()).add("HttpVersion", (Object)this.httpVersionString()).add("IsIPV6Enabled", (Object)this.isIPV6Enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.of(clazz.cast(this.lastModifiedTime()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Aliases": {
                return Optional.of(clazz.cast(this.aliases()));
            }
            case "Origins": {
                return Optional.of(clazz.cast(this.origins()));
            }
            case "DefaultCacheBehavior": {
                return Optional.of(clazz.cast(this.defaultCacheBehavior()));
            }
            case "CacheBehaviors": {
                return Optional.of(clazz.cast(this.cacheBehaviors()));
            }
            case "CustomErrorResponses": {
                return Optional.of(clazz.cast(this.customErrorResponses()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "PriceClass": {
                return Optional.of(clazz.cast(this.priceClassString()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "ViewerCertificate": {
                return Optional.of(clazz.cast(this.viewerCertificate()));
            }
            case "Restrictions": {
                return Optional.of(clazz.cast(this.restrictions()));
            }
            case "WebACLId": {
                return Optional.of(clazz.cast(this.webACLId()));
            }
            case "HttpVersion": {
                return Optional.of(clazz.cast(this.httpVersionString()));
            }
            case "IsIPV6Enabled": {
                return Optional.of(clazz.cast(this.isIPV6Enabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private Instant lastModifiedTime;
        private String domainName;
        private Aliases aliases;
        private Origins origins;
        private DefaultCacheBehavior defaultCacheBehavior;
        private CacheBehaviors cacheBehaviors;
        private CustomErrorResponses customErrorResponses;
        private String comment;
        private String priceClass;
        private Boolean enabled;
        private ViewerCertificate viewerCertificate;
        private Restrictions restrictions;
        private String webACLId;
        private String httpVersion;
        private Boolean isIPV6Enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.domainName(model.domainName);
            this.aliases(model.aliases);
            this.origins(model.origins);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviors(model.cacheBehaviors);
            this.customErrorResponses(model.customErrorResponses);
            this.comment(model.comment);
            this.priceClass(model.priceClass);
            this.enabled(model.enabled);
            this.viewerCertificate(model.viewerCertificate);
            this.restrictions(model.restrictions);
            this.webACLId(model.webACLId);
            this.httpVersion(model.httpVersion);
            this.isIPV6Enabled(model.isIPV6Enabled);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Aliases.Builder getAliases() {
            return this.aliases != null ? this.aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final Origins.Builder getOrigins() {
            return this.origins != null ? this.origins.toBuilder() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return this.cacheBehaviors != null ? this.cacheBehaviors.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return this.customErrorResponses != null ? this.customErrorResponses.toBuilder() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getPriceClass() {
            return this.priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return this.viewerCertificate != null ? this.viewerCertificate.toBuilder() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        public final Restrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getHttpVersion() {
            return this.httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion.toString());
            return this;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Boolean getIsIPV6Enabled() {
            return this.isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        public DistributionSummary build() {
            return new DistributionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DistributionSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder domainName(String var1);

        public Builder aliases(Aliases var1);

        default public Builder aliases(Consumer<Aliases.Builder> aliases) {
            return this.aliases((Aliases)((Aliases.Builder)Aliases.builder().apply(aliases)).build());
        }

        public Builder origins(Origins var1);

        default public Builder origins(Consumer<Origins.Builder> origins) {
            return this.origins((Origins)((Origins.Builder)Origins.builder().apply(origins)).build());
        }

        public Builder defaultCacheBehavior(DefaultCacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((DefaultCacheBehavior)((DefaultCacheBehavior.Builder)DefaultCacheBehavior.builder().apply(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviors(CacheBehaviors var1);

        default public Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return this.cacheBehaviors((CacheBehaviors)((CacheBehaviors.Builder)CacheBehaviors.builder().apply(cacheBehaviors)).build());
        }

        public Builder customErrorResponses(CustomErrorResponses var1);

        default public Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return this.customErrorResponses((CustomErrorResponses)((CustomErrorResponses.Builder)CustomErrorResponses.builder().apply(customErrorResponses)).build());
        }

        public Builder comment(String var1);

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);

        public Builder viewerCertificate(ViewerCertificate var1);

        default public Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return this.viewerCertificate((ViewerCertificate)((ViewerCertificate.Builder)ViewerCertificate.builder().apply(viewerCertificate)).build());
        }

        public Builder restrictions(Restrictions var1);

        default public Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return this.restrictions((Restrictions)((Restrictions.Builder)Restrictions.builder().apply(restrictions)).build());
        }

        public Builder webACLId(String var1);

        public Builder httpVersion(String var1);

        public Builder httpVersion(HttpVersion var1);

        public Builder isIPV6Enabled(Boolean var1);
    }
}

