/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum ViewerProtocolPolicy {
    AllowAll("allow-all"),
    HttpsOnly("https-only"),
    RedirectToHttps("redirect-to-https");

    private final String value;

    private ViewerProtocolPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ViewerProtocolPolicy fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(ViewerProtocolPolicy.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

