/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.auth;

public enum PemObjectType {
    PRIVATE_KEY_PKCS1("-----BEGIN RSA PRIVATE KEY-----"),
    PRIVATE_KEY_PKCS8("-----BEGIN PRIVATE KEY-----"),
    PUBLIC_KEY_X509("-----BEGIN PUBLIC KEY-----"),
    CERTIFICATE_X509("-----BEGIN CERTIFICATE-----");

    private final String beginMarker;

    private PemObjectType(String beginMarker) {
        this.beginMarker = beginMarker;
    }

    public static PemObjectType fromBeginMarker(String beginMarker) {
        for (PemObjectType e : PemObjectType.values()) {
            if (!e.getBeginMarker().equals(beginMarker)) continue;
            return e;
        }
        return null;
    }

    public String getBeginMarker() {
        return this.beginMarker;
    }
}

