/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import software.amazon.awssdk.services.cloudfront.transform.CloudFrontOriginAccessIdentitySummaryUnmarshaller;

public class CloudFrontOriginAccessIdentityListUnmarshaller
implements Unmarshaller<CloudFrontOriginAccessIdentityList, StaxUnmarshallerContext> {
    private static final CloudFrontOriginAccessIdentityListUnmarshaller INSTANCE = new CloudFrontOriginAccessIdentityListUnmarshaller();

    public CloudFrontOriginAccessIdentityList unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudFrontOriginAccessIdentityList.Builder cloudFrontOriginAccessIdentityList;
        block10: {
            cloudFrontOriginAccessIdentityList = CloudFrontOriginAccessIdentityList.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<CloudFrontOriginAccessIdentitySummary> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cloudFrontOriginAccessIdentityList.items(items);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Marker", targetDepth)) {
                        cloudFrontOriginAccessIdentityList.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextMarker", targetDepth)) {
                        cloudFrontOriginAccessIdentityList.nextMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxItems", targetDepth)) {
                        cloudFrontOriginAccessIdentityList.maxItems(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        cloudFrontOriginAccessIdentityList.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Quantity", targetDepth)) {
                        cloudFrontOriginAccessIdentityList.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<CloudFrontOriginAccessIdentitySummary>();
                        continue;
                    }
                    if (!context.testExpression("Items/CloudFrontOriginAccessIdentitySummary", targetDepth)) continue;
                    items.add(CloudFrontOriginAccessIdentitySummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cloudFrontOriginAccessIdentityList.items(items);
        }
        return (CloudFrontOriginAccessIdentityList)cloudFrontOriginAccessIdentityList.build();
    }

    public static CloudFrontOriginAccessIdentityListUnmarshaller getInstance() {
        return INSTANCE;
    }
}

