/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;

public class DeleteDistributionRequestMarshaller
implements Marshaller<Request<DeleteDistributionRequest>, DeleteDistributionRequest> {
    public Request<DeleteDistributionRequest> marshall(DeleteDistributionRequest deleteDistributionRequest) {
        if (deleteDistributionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDistributionRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteDistributionRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringConversion.fromString((String)deleteDistributionRequest.ifMatch()));
        }
        String uriResourcePath = "/2017-03-25/distribution/{Id}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Id", deleteDistributionRequest.id());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

