/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Tag;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.services.cloudfront.transform.TagUnmarshaller;

public class TagsUnmarshaller
implements Unmarshaller<Tags, StaxUnmarshallerContext> {
    private static final TagsUnmarshaller INSTANCE = new TagsUnmarshaller();

    public Tags unmarshall(StaxUnmarshallerContext context) throws Exception {
        Tags.Builder tags;
        block5: {
            tags = Tags.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    tags.items(items);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Items/Tag", targetDepth)) continue;
                    items.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            tags.items(items);
        }
        return (Tags)tags.build();
    }

    public static TagsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

