/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;

public class ListInvalidationsPublisher
implements SdkPublisher<ListInvalidationsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListInvalidationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvalidationsPublisher(CloudFrontAsyncClient client, ListInvalidationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvalidationsPublisher(CloudFrontAsyncClient client, ListInvalidationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvalidationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvalidationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<InvalidationSummary> items() {
        Function<ListInvalidationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invalidationList() != null && response.invalidationList().items() != null) {
                return response.invalidationList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListInvalidationsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListInvalidationsPublisher resume(ListInvalidationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInvalidationsPublisher(this.client, (ListInvalidationsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.invalidationList().nextMarker()).build()));
        }
        return new ListInvalidationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInvalidationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInvalidationsResponseFetcher
    implements AsyncPageFetcher<ListInvalidationsResponse> {
        private ListInvalidationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvalidationsResponse previousPage) {
            return previousPage.invalidationList().isTruncated();
        }

        public CompletableFuture<ListInvalidationsResponse> nextPage(ListInvalidationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvalidationsPublisher.this.client.listInvalidations(ListInvalidationsPublisher.this.firstRequest);
            }
            return ListInvalidationsPublisher.this.client.listInvalidations((ListInvalidationsRequest)((Object)ListInvalidationsPublisher.this.firstRequest.toBuilder().marker(previousPage.invalidationList().nextMarker()).build()));
        }
    }
}

