/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.KeyPairIds;

public class KeyPairIdsUnmarshaller
implements Unmarshaller<KeyPairIds, StaxUnmarshallerContext> {
    private static KeyPairIdsUnmarshaller INSTANCE;

    public KeyPairIds unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        KeyPairIds.Builder keyPairIds = KeyPairIds.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    keyPairIds.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    keyPairIds.items(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/KeyPairId", targetDepth)) continue;
                keyPairIds.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (KeyPairIds)keyPairIds.build();
    }

    public static KeyPairIdsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeyPairIdsUnmarshaller();
        }
        return INSTANCE;
    }
}

