/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader;
import software.amazon.awssdk.services.cloudfront.transform.OriginCustomHeaderUnmarshaller;

public class CustomHeadersUnmarshaller
implements Unmarshaller<CustomHeaders, StaxUnmarshallerContext> {
    private static CustomHeadersUnmarshaller INSTANCE;

    public CustomHeaders unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CustomHeaders.Builder customHeaders = CustomHeaders.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    customHeaders.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    customHeaders.items(new ArrayList<OriginCustomHeader>());
                    continue;
                }
                if (!context.testExpression("Items/OriginCustomHeader", targetDepth)) continue;
                customHeaders.items(OriginCustomHeaderUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CustomHeaders)customHeaders.build();
    }

    public static CustomHeadersUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomHeadersUnmarshaller();
        }
        return INSTANCE;
    }
}

