/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.transform.CustomErrorResponseUnmarshaller;

public class CustomErrorResponsesUnmarshaller
implements Unmarshaller<CustomErrorResponses, StaxUnmarshallerContext> {
    private static CustomErrorResponsesUnmarshaller INSTANCE;

    public CustomErrorResponses unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CustomErrorResponses.Builder customErrorResponses = CustomErrorResponses.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    customErrorResponses.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    customErrorResponses.items(new ArrayList<CustomErrorResponse>());
                    continue;
                }
                if (!context.testExpression("Items/CustomErrorResponse", targetDepth)) continue;
                customErrorResponses.items(CustomErrorResponseUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CustomErrorResponses)customErrorResponses.build();
    }

    public static CustomErrorResponsesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomErrorResponsesUnmarshaller();
        }
        return INSTANCE;
    }
}

