/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CookieNames;

public class CookieNamesUnmarshaller
implements Unmarshaller<CookieNames, StaxUnmarshallerContext> {
    private static CookieNamesUnmarshaller INSTANCE;

    public CookieNames unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CookieNames.Builder cookieNames = CookieNames.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    cookieNames.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    cookieNames.items(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/Name", targetDepth)) continue;
                cookieNames.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CookieNames)cookieNames.build();
    }

    public static CookieNamesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CookieNamesUnmarshaller();
        }
        return INSTANCE;
    }
}

