/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.transform.CacheBehaviorUnmarshaller;

public class CacheBehaviorsUnmarshaller
implements Unmarshaller<CacheBehaviors, StaxUnmarshallerContext> {
    private static CacheBehaviorsUnmarshaller INSTANCE;

    public CacheBehaviors unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CacheBehaviors.Builder cacheBehaviors = CacheBehaviors.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    cacheBehaviors.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    cacheBehaviors.items(new ArrayList<CacheBehavior>());
                    continue;
                }
                if (!context.testExpression("Items/CacheBehavior", targetDepth)) continue;
                cacheBehaviors.items(CacheBehaviorUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CacheBehaviors)cacheBehaviors.build();
    }

    public static CacheBehaviorsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheBehaviorsUnmarshaller();
        }
        return INSTANCE;
    }
}

