/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetType;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.DeploymentMode;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.OnStackFailure;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceToImport;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourcesToImportCopier;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChangeSetRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, CreateChangeSetRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::stackName)).setter(CreateChangeSetRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::templateBody)).setter(CreateChangeSetRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateURL").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::templateURL)).setter(CreateChangeSetRequest.setter(Builder::templateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()}).build();
    private static final SdkField<Boolean> USE_PREVIOUS_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UsePreviousTemplate").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::usePreviousTemplate)).setter(CreateChangeSetRequest.setter(Builder::usePreviousTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousTemplate").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::parameters)).setter(CreateChangeSetRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::capabilitiesAsStrings)).setter(CreateChangeSetRequest.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::resourceTypes)).setter(CreateChangeSetRequest.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::roleARN)).setter(CreateChangeSetRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollbackConfiguration").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::rollbackConfiguration)).setter(CreateChangeSetRequest.setter(Builder::rollbackConfiguration)).constructor(RollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackConfiguration").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotificationARNs").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::notificationARNs)).setter(CreateChangeSetRequest.setter(Builder::notificationARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::tags)).setter(CreateChangeSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetName").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::changeSetName)).setter(CreateChangeSetRequest.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::clientToken)).setter(CreateChangeSetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::description)).setter(CreateChangeSetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CHANGE_SET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetType").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::changeSetTypeAsString)).setter(CreateChangeSetRequest.setter(Builder::changeSetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetType").build()}).build();
    private static final SdkField<List<ResourceToImport>> RESOURCES_TO_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourcesToImport").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::resourcesToImport)).setter(CreateChangeSetRequest.setter(Builder::resourcesToImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesToImport").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceToImport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_NESTED_STACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeNestedStacks").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::includeNestedStacks)).setter(CreateChangeSetRequest.setter(Builder::includeNestedStacks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNestedStacks").build()}).build();
    private static final SdkField<String> ON_STACK_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnStackFailure").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::onStackFailureAsString)).setter(CreateChangeSetRequest.setter(Builder::onStackFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStackFailure").build()}).build();
    private static final SdkField<Boolean> IMPORT_EXISTING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ImportExistingResources").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::importExistingResources)).setter(CreateChangeSetRequest.setter(Builder::importExistingResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportExistingResources").build()}).build();
    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentMode").getter(CreateChangeSetRequest.getter(CreateChangeSetRequest::deploymentModeAsString)).setter(CreateChangeSetRequest.setter(Builder::deploymentMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, USE_PREVIOUS_TEMPLATE_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD, RESOURCE_TYPES_FIELD, ROLE_ARN_FIELD, ROLLBACK_CONFIGURATION_FIELD, NOTIFICATION_AR_NS_FIELD, TAGS_FIELD, CHANGE_SET_NAME_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, CHANGE_SET_TYPE_FIELD, RESOURCES_TO_IMPORT_FIELD, INCLUDE_NESTED_STACKS_FIELD, ON_STACK_FAILURE_FIELD, IMPORT_EXISTING_RESOURCES_FIELD, DEPLOYMENT_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateChangeSetRequest.memberNameToFieldInitializer();
    private final String stackName;
    private final String templateBody;
    private final String templateURL;
    private final Boolean usePreviousTemplate;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<String> resourceTypes;
    private final String roleARN;
    private final RollbackConfiguration rollbackConfiguration;
    private final List<String> notificationARNs;
    private final List<Tag> tags;
    private final String changeSetName;
    private final String clientToken;
    private final String description;
    private final String changeSetType;
    private final List<ResourceToImport> resourcesToImport;
    private final Boolean includeNestedStacks;
    private final String onStackFailure;
    private final Boolean importExistingResources;
    private final String deploymentMode;

    private CreateChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.changeSetName = builder.changeSetName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.changeSetType = builder.changeSetType;
        this.resourcesToImport = builder.resourcesToImport;
        this.includeNestedStacks = builder.includeNestedStacks;
        this.onStackFailure = builder.onStackFailure;
        this.importExistingResources = builder.importExistingResources;
        this.deploymentMode = builder.deploymentMode;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final String templateURL() {
        return this.templateURL;
    }

    public final Boolean usePreviousTemplate() {
        return this.usePreviousTemplate;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameters() {
        return this.parameters;
    }

    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final RollbackConfiguration rollbackConfiguration() {
        return this.rollbackConfiguration;
    }

    public final boolean hasNotificationARNs() {
        return this.notificationARNs != null && !(this.notificationARNs instanceof SdkAutoConstructList);
    }

    public final List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String changeSetName() {
        return this.changeSetName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final ChangeSetType changeSetType() {
        return ChangeSetType.fromValue(this.changeSetType);
    }

    public final String changeSetTypeAsString() {
        return this.changeSetType;
    }

    public final boolean hasResourcesToImport() {
        return this.resourcesToImport != null && !(this.resourcesToImport instanceof SdkAutoConstructList);
    }

    public final List<ResourceToImport> resourcesToImport() {
        return this.resourcesToImport;
    }

    public final Boolean includeNestedStacks() {
        return this.includeNestedStacks;
    }

    public final OnStackFailure onStackFailure() {
        return OnStackFailure.fromValue(this.onStackFailure);
    }

    public final String onStackFailureAsString() {
        return this.onStackFailure;
    }

    public final Boolean importExistingResources() {
        return this.importExistingResources;
    }

    public final DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(this.deploymentMode);
    }

    public final String deploymentModeAsString() {
        return this.deploymentMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePreviousTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationARNs() ? this.notificationARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesToImport() ? this.resourcesToImport() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeNestedStacks());
        hashCode = 31 * hashCode + Objects.hashCode(this.onStackFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importExistingResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangeSetRequest)) {
            return false;
        }
        CreateChangeSetRequest other = (CreateChangeSetRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.usePreviousTemplate(), other.usePreviousTemplate()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.rollbackConfiguration(), other.rollbackConfiguration()) && this.hasNotificationARNs() == other.hasNotificationARNs() && Objects.equals(this.notificationARNs(), other.notificationARNs()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.changeSetTypeAsString(), other.changeSetTypeAsString()) && this.hasResourcesToImport() == other.hasResourcesToImport() && Objects.equals(this.resourcesToImport(), other.resourcesToImport()) && Objects.equals(this.includeNestedStacks(), other.includeNestedStacks()) && Objects.equals(this.onStackFailureAsString(), other.onStackFailureAsString()) && Objects.equals(this.importExistingResources(), other.importExistingResources()) && Objects.equals(this.deploymentModeAsString(), other.deploymentModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChangeSetRequest").add("StackName", (Object)this.stackName()).add("TemplateBody", (Object)this.templateBody()).add("TemplateURL", (Object)this.templateURL()).add("UsePreviousTemplate", (Object)this.usePreviousTemplate()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("RoleARN", (Object)this.roleARN()).add("RollbackConfiguration", (Object)this.rollbackConfiguration()).add("NotificationARNs", this.hasNotificationARNs() ? this.notificationARNs() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ChangeSetName", (Object)this.changeSetName()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("ChangeSetType", (Object)this.changeSetTypeAsString()).add("ResourcesToImport", this.hasResourcesToImport() ? this.resourcesToImport() : null).add("IncludeNestedStacks", (Object)this.includeNestedStacks()).add("OnStackFailure", (Object)this.onStackFailureAsString()).add("ImportExistingResources", (Object)this.importExistingResources()).add("DeploymentMode", (Object)this.deploymentModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.ofNullable(clazz.cast(this.templateURL()));
            }
            case "UsePreviousTemplate": {
                return Optional.ofNullable(clazz.cast(this.usePreviousTemplate()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "RollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rollbackConfiguration()));
            }
            case "NotificationARNs": {
                return Optional.ofNullable(clazz.cast(this.notificationARNs()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ChangeSetType": {
                return Optional.ofNullable(clazz.cast(this.changeSetTypeAsString()));
            }
            case "ResourcesToImport": {
                return Optional.ofNullable(clazz.cast(this.resourcesToImport()));
            }
            case "IncludeNestedStacks": {
                return Optional.ofNullable(clazz.cast(this.includeNestedStacks()));
            }
            case "OnStackFailure": {
                return Optional.ofNullable(clazz.cast(this.onStackFailureAsString()));
            }
            case "ImportExistingResources": {
                return Optional.ofNullable(clazz.cast(this.importExistingResources()));
            }
            case "DeploymentMode": {
                return Optional.ofNullable(clazz.cast(this.deploymentModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("TemplateBody", TEMPLATE_BODY_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("UsePreviousTemplate", USE_PREVIOUS_TEMPLATE_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("RollbackConfiguration", ROLLBACK_CONFIGURATION_FIELD);
        map.put("NotificationARNs", NOTIFICATION_AR_NS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ChangeSetType", CHANGE_SET_TYPE_FIELD);
        map.put("ResourcesToImport", RESOURCES_TO_IMPORT_FIELD);
        map.put("IncludeNestedStacks", INCLUDE_NESTED_STACKS_FIELD);
        map.put("OnStackFailure", ON_STACK_FAILURE_FIELD);
        map.put("ImportExistingResources", IMPORT_EXISTING_RESOURCES_FIELD);
        map.put("DeploymentMode", DEPLOYMENT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChangeSetRequest, T> g) {
        return obj -> g.apply((CreateChangeSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String templateBody;
        private String templateURL;
        private Boolean usePreviousTemplate;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String roleARN;
        private RollbackConfiguration rollbackConfiguration;
        private List<String> notificationARNs = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String changeSetName;
        private String clientToken;
        private String description;
        private String changeSetType;
        private List<ResourceToImport> resourcesToImport = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeNestedStacks;
        private String onStackFailure;
        private Boolean importExistingResources;
        private String deploymentMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangeSetRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.usePreviousTemplate(model.usePreviousTemplate);
            this.parameters(model.parameters);
            this.capabilitiesWithStrings(model.capabilities);
            this.resourceTypes(model.resourceTypes);
            this.roleARN(model.roleARN);
            this.rollbackConfiguration(model.rollbackConfiguration);
            this.notificationARNs(model.notificationARNs);
            this.tags(model.tags);
            this.changeSetName(model.changeSetName);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.changeSetType(model.changeSetType);
            this.resourcesToImport(model.resourcesToImport);
            this.includeNestedStacks(model.includeNestedStacks);
            this.onStackFailure(model.onStackFailure);
            this.importExistingResources(model.importExistingResources);
            this.deploymentMode(model.deploymentMode);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final Boolean getUsePreviousTemplate() {
            return this.usePreviousTemplate;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return this.rollbackConfiguration != null ? this.rollbackConfiguration.toBuilder() : null;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final Collection<String> getNotificationARNs() {
            if (this.notificationARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notificationARNs;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getChangeSetType() {
            return this.changeSetType;
        }

        public final void setChangeSetType(String changeSetType) {
            this.changeSetType = changeSetType;
        }

        @Override
        public final Builder changeSetType(String changeSetType) {
            this.changeSetType = changeSetType;
            return this;
        }

        @Override
        public final Builder changeSetType(ChangeSetType changeSetType) {
            this.changeSetType(changeSetType == null ? null : changeSetType.toString());
            return this;
        }

        public final List<ResourceToImport.Builder> getResourcesToImport() {
            List<ResourceToImport.Builder> result = ResourcesToImportCopier.copyToBuilder(this.resourcesToImport);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcesToImport(Collection<ResourceToImport.BuilderImpl> resourcesToImport) {
            this.resourcesToImport = ResourcesToImportCopier.copyFromBuilder(resourcesToImport);
        }

        @Override
        public final Builder resourcesToImport(Collection<ResourceToImport> resourcesToImport) {
            this.resourcesToImport = ResourcesToImportCopier.copy(resourcesToImport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToImport(ResourceToImport ... resourcesToImport) {
            this.resourcesToImport(Arrays.asList(resourcesToImport));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToImport(Consumer<ResourceToImport.Builder> ... resourcesToImport) {
            this.resourcesToImport(Stream.of(resourcesToImport).map(c -> (ResourceToImport)((ResourceToImport.Builder)ResourceToImport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeNestedStacks() {
            return this.includeNestedStacks;
        }

        public final void setIncludeNestedStacks(Boolean includeNestedStacks) {
            this.includeNestedStacks = includeNestedStacks;
        }

        @Override
        public final Builder includeNestedStacks(Boolean includeNestedStacks) {
            this.includeNestedStacks = includeNestedStacks;
            return this;
        }

        public final String getOnStackFailure() {
            return this.onStackFailure;
        }

        public final void setOnStackFailure(String onStackFailure) {
            this.onStackFailure = onStackFailure;
        }

        @Override
        public final Builder onStackFailure(String onStackFailure) {
            this.onStackFailure = onStackFailure;
            return this;
        }

        @Override
        public final Builder onStackFailure(OnStackFailure onStackFailure) {
            this.onStackFailure(onStackFailure == null ? null : onStackFailure.toString());
            return this;
        }

        public final Boolean getImportExistingResources() {
            return this.importExistingResources;
        }

        public final void setImportExistingResources(Boolean importExistingResources) {
            this.importExistingResources = importExistingResources;
        }

        @Override
        public final Builder importExistingResources(Boolean importExistingResources) {
            this.importExistingResources = importExistingResources;
            return this;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChangeSetRequest build() {
            return new CreateChangeSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChangeSetRequest> {
        public Builder stackName(String var1);

        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder usePreviousTemplate(Boolean var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder roleARN(String var1);

        public Builder rollbackConfiguration(RollbackConfiguration var1);

        default public Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return this.rollbackConfiguration((RollbackConfiguration)((RollbackConfiguration.Builder)RollbackConfiguration.builder().applyMutation(rollbackConfiguration)).build());
        }

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder changeSetName(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder changeSetType(String var1);

        public Builder changeSetType(ChangeSetType var1);

        public Builder resourcesToImport(Collection<ResourceToImport> var1);

        public Builder resourcesToImport(ResourceToImport ... var1);

        public Builder resourcesToImport(Consumer<ResourceToImport.Builder> ... var1);

        public Builder includeNestedStacks(Boolean var1);

        public Builder onStackFailure(String var1);

        public Builder onStackFailure(OnStackFailure var1);

        public Builder importExistingResources(Boolean var1);

        public Builder deploymentMode(String var1);

        public Builder deploymentMode(DeploymentMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

