/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about an event that occurred during a CloudFormation operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationEvent implements SdkPojo, Serializable, ToCopyableBuilder<OperationEvent.Builder, OperationEvent> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(OperationEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(OperationEvent::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(OperationEvent::operationId)).setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationType").getter(getter(OperationEvent::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType").build()).build();

    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationStatus").getter(getter(OperationEvent::operationStatusAsString))
            .setter(setter(Builder::operationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(OperationEvent::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalResourceId").getter(getter(OperationEvent::logicalResourceId))
            .setter(setter(Builder::logicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()).build();

    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhysicalResourceId").getter(getter(OperationEvent::physicalResourceId))
            .setter(setter(Builder::physicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(OperationEvent::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(OperationEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(OperationEvent::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(OperationEvent::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatus").getter(getter(OperationEvent::resourceStatusAsString))
            .setter(setter(Builder::resourceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatusReason").getter(getter(OperationEvent::resourceStatusReason))
            .setter(setter(Builder::resourceStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatusReason").build())
            .build();

    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceProperties").getter(getter(OperationEvent::resourceProperties))
            .setter(setter(Builder::resourceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(OperationEvent::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<String> HOOK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookType").getter(getter(OperationEvent::hookType)).setter(setter(Builder::hookType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookType").build()).build();

    private static final SdkField<String> HOOK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatus").getter(getter(OperationEvent::hookStatusAsString)).setter(setter(Builder::hookStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatus").build()).build();

    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatusReason").getter(getter(OperationEvent::hookStatusReason))
            .setter(setter(Builder::hookStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()).build();

    private static final SdkField<String> HOOK_INVOCATION_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookInvocationPoint").getter(getter(OperationEvent::hookInvocationPointAsString))
            .setter(setter(Builder::hookInvocationPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookInvocationPoint").build())
            .build();

    private static final SdkField<String> HOOK_FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookFailureMode").getter(getter(OperationEvent::hookFailureModeAsString))
            .setter(setter(Builder::hookFailureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookFailureMode").build()).build();

    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(OperationEvent::detailedStatusAsString))
            .setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final SdkField<String> VALIDATION_FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationFailureMode").getter(getter(OperationEvent::validationFailureModeAsString))
            .setter(setter(Builder::validationFailureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailureMode").build())
            .build();

    private static final SdkField<String> VALIDATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationName").getter(getter(OperationEvent::validationName)).setter(setter(Builder::validationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationName").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatus").getter(getter(OperationEvent::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatusReason").getter(getter(OperationEvent::validationStatusReason))
            .setter(setter(Builder::validationStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatusReason").build())
            .build();

    private static final SdkField<String> VALIDATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationPath").getter(getter(OperationEvent::validationPath)).setter(setter(Builder::validationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            STACK_ID_FIELD, OPERATION_ID_FIELD, OPERATION_TYPE_FIELD, OPERATION_STATUS_FIELD, EVENT_TYPE_FIELD,
            LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TIMESTAMP_FIELD, START_TIME_FIELD,
            END_TIME_FIELD, RESOURCE_STATUS_FIELD, RESOURCE_STATUS_REASON_FIELD, RESOURCE_PROPERTIES_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, HOOK_TYPE_FIELD, HOOK_STATUS_FIELD, HOOK_STATUS_REASON_FIELD,
            HOOK_INVOCATION_POINT_FIELD, HOOK_FAILURE_MODE_FIELD, DETAILED_STATUS_FIELD, VALIDATION_FAILURE_MODE_FIELD,
            VALIDATION_NAME_FIELD, VALIDATION_STATUS_FIELD, VALIDATION_STATUS_REASON_FIELD, VALIDATION_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String stackId;

    private final String operationId;

    private final String operationType;

    private final String operationStatus;

    private final String eventType;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final Instant timestamp;

    private final Instant startTime;

    private final Instant endTime;

    private final String resourceStatus;

    private final String resourceStatusReason;

    private final String resourceProperties;

    private final String clientRequestToken;

    private final String hookType;

    private final String hookStatus;

    private final String hookStatusReason;

    private final String hookInvocationPoint;

    private final String hookFailureMode;

    private final String detailedStatus;

    private final String validationFailureMode;

    private final String validationName;

    private final String validationStatus;

    private final String validationStatusReason;

    private final String validationPath;

    private OperationEvent(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.stackId = builder.stackId;
        this.operationId = builder.operationId;
        this.operationType = builder.operationType;
        this.operationStatus = builder.operationStatus;
        this.eventType = builder.eventType;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.resourceProperties = builder.resourceProperties;
        this.clientRequestToken = builder.clientRequestToken;
        this.hookType = builder.hookType;
        this.hookStatus = builder.hookStatus;
        this.hookStatusReason = builder.hookStatusReason;
        this.hookInvocationPoint = builder.hookInvocationPoint;
        this.hookFailureMode = builder.hookFailureMode;
        this.detailedStatus = builder.detailedStatus;
        this.validationFailureMode = builder.validationFailureMode;
        this.validationName = builder.validationName;
        this.validationStatus = builder.validationStatus;
        this.validationStatusReason = builder.validationStatusReason;
        this.validationPath = builder.validationPath;
    }

    /**
     * <p>
     * A unique identifier for this event.
     * </p>
     * 
     * @return A unique identifier for this event.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The unique ID name of the instance of the stack.
     * </p>
     * 
     * @return The unique ID name of the instance of the stack.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The unique identifier of the operation this event belongs to.
     * </p>
     * 
     * @return The unique identifier of the operation this event belongs to.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public final OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The current status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link BeaconStackOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return The current status of the operation.
     * @see BeaconStackOperationStatus
     */
    public final BeaconStackOperationStatus operationStatus() {
        return BeaconStackOperationStatus.fromValue(operationStatus);
    }

    /**
     * <p>
     * The current status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link BeaconStackOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return The current status of the operation.
     * @see BeaconStackOperationStatus
     */
    public final String operationStatusAsString() {
        return operationStatus;
    }

    /**
     * <p>
     * The type of event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The logical name of the resource as specified in the template.
     * </p>
     * 
     * @return The logical name of the resource as specified in the template.
     */
    public final String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier that corresponds to a physical instance ID of a resource.
     * </p>
     * 
     * @return The name or unique identifier that corresponds to a physical instance ID of a resource.
     */
    public final String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * Type of resource.
     * </p>
     * 
     * @return Type of resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Time the status was updated.
     * </p>
     * 
     * @return Time the status was updated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The time when the event started.
     * </p>
     * 
     * @return The time when the event started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the event ended.
     * </p>
     * 
     * @return The time when the event ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(resourceStatus);
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public final String resourceStatusAsString() {
        return resourceStatus;
    }

    /**
     * <p>
     * Success or failure message associated with the resource.
     * </p>
     * 
     * @return Success or failure message associated with the resource.
     */
    public final String resourceStatusReason() {
        return resourceStatusReason;
    }

    /**
     * <p>
     * The properties used to create the resource.
     * </p>
     * 
     * @return The properties used to create the resource.
     */
    public final String resourceProperties() {
        return resourceProperties;
    }

    /**
     * <p>
     * A unique identifier for the request that initiated this operation.
     * </p>
     * 
     * @return A unique identifier for the request that initiated this operation.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The type name of the Hook that was invoked.
     * </p>
     * 
     * @return The type name of the Hook that was invoked.
     */
    public final String hookType() {
        return hookType;
    }

    /**
     * <p>
     * The status of the Hook invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookStatus} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hookStatusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation.
     * @see HookStatus
     */
    public final HookStatus hookStatus() {
        return HookStatus.fromValue(hookStatus);
    }

    /**
     * <p>
     * The status of the Hook invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookStatus} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hookStatusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation.
     * @see HookStatus
     */
    public final String hookStatusAsString() {
        return hookStatus;
    }

    /**
     * <p>
     * Additional information about the Hook status.
     * </p>
     * 
     * @return Additional information about the Hook status.
     */
    public final String hookStatusReason() {
        return hookStatusReason;
    }

    /**
     * <p>
     * The point in the operation lifecycle when the Hook was invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hookInvocationPoint} will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hookInvocationPointAsString}.
     * </p>
     * 
     * @return The point in the operation lifecycle when the Hook was invoked.
     * @see HookInvocationPoint
     */
    public final HookInvocationPoint hookInvocationPoint() {
        return HookInvocationPoint.fromValue(hookInvocationPoint);
    }

    /**
     * <p>
     * The point in the operation lifecycle when the Hook was invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hookInvocationPoint} will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hookInvocationPointAsString}.
     * </p>
     * 
     * @return The point in the operation lifecycle when the Hook was invoked.
     * @see HookInvocationPoint
     */
    public final String hookInvocationPointAsString() {
        return hookInvocationPoint;
    }

    /**
     * <p>
     * Specifies how Hook failures are handled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookFailureMode}
     * will return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hookFailureModeAsString}.
     * </p>
     * 
     * @return Specifies how Hook failures are handled.
     * @see HookFailureMode
     */
    public final HookFailureMode hookFailureMode() {
        return HookFailureMode.fromValue(hookFailureMode);
    }

    /**
     * <p>
     * Specifies how Hook failures are handled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookFailureMode}
     * will return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hookFailureModeAsString}.
     * </p>
     * 
     * @return Specifies how Hook failures are handled.
     * @see HookFailureMode
     */
    public final String hookFailureModeAsString() {
        return hookFailureMode;
    }

    /**
     * <p>
     * Additional status information about the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link DetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return Additional status information about the operation.
     * @see DetailedStatus
     */
    public final DetailedStatus detailedStatus() {
        return DetailedStatus.fromValue(detailedStatus);
    }

    /**
     * <p>
     * Additional status information about the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link DetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return Additional status information about the operation.
     * @see DetailedStatus
     */
    public final String detailedStatusAsString() {
        return detailedStatus;
    }

    /**
     * <p>
     * Specifies how validation failures are handled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationFailureMode} will return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #validationFailureModeAsString}.
     * </p>
     * 
     * @return Specifies how validation failures are handled.
     * @see HookFailureMode
     */
    public final HookFailureMode validationFailureMode() {
        return HookFailureMode.fromValue(validationFailureMode);
    }

    /**
     * <p>
     * Specifies how validation failures are handled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationFailureMode} will return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #validationFailureModeAsString}.
     * </p>
     * 
     * @return Specifies how validation failures are handled.
     * @see HookFailureMode
     */
    public final String validationFailureModeAsString() {
        return validationFailureMode;
    }

    /**
     * <p>
     * The name of the validation that was performed.
     * </p>
     * 
     * @return The name of the validation that was performed.
     */
    public final String validationName() {
        return validationName;
    }

    /**
     * <p>
     * The status of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link ValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The status of the validation.
     * @see ValidationStatus
     */
    public final ValidationStatus validationStatus() {
        return ValidationStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * The status of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link ValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The status of the validation.
     * @see ValidationStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    /**
     * <p>
     * Additional information about the validation status.
     * </p>
     * 
     * @return Additional information about the validation status.
     */
    public final String validationStatusReason() {
        return validationStatusReason;
    }

    /**
     * <p>
     * The path within the resource where the validation was applied.
     * </p>
     * 
     * @return The path within the resource where the validation was applied.
     */
    public final String validationPath() {
        return validationPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(resourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hookType());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hookInvocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookFailureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validationFailureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validationName());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(validationPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationEvent)) {
            return false;
        }
        OperationEvent other = (OperationEvent) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(operationId(), other.operationId())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(operationStatusAsString(), other.operationStatusAsString())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(resourceStatusAsString(), other.resourceStatusAsString())
                && Objects.equals(resourceStatusReason(), other.resourceStatusReason())
                && Objects.equals(resourceProperties(), other.resourceProperties())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(hookType(), other.hookType())
                && Objects.equals(hookStatusAsString(), other.hookStatusAsString())
                && Objects.equals(hookStatusReason(), other.hookStatusReason())
                && Objects.equals(hookInvocationPointAsString(), other.hookInvocationPointAsString())
                && Objects.equals(hookFailureModeAsString(), other.hookFailureModeAsString())
                && Objects.equals(detailedStatusAsString(), other.detailedStatusAsString())
                && Objects.equals(validationFailureModeAsString(), other.validationFailureModeAsString())
                && Objects.equals(validationName(), other.validationName())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString())
                && Objects.equals(validationStatusReason(), other.validationStatusReason())
                && Objects.equals(validationPath(), other.validationPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperationEvent").add("EventId", eventId()).add("StackId", stackId())
                .add("OperationId", operationId()).add("OperationType", operationTypeAsString())
                .add("OperationStatus", operationStatusAsString()).add("EventType", eventTypeAsString())
                .add("LogicalResourceId", logicalResourceId()).add("PhysicalResourceId", physicalResourceId())
                .add("ResourceType", resourceType()).add("Timestamp", timestamp()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("ResourceStatus", resourceStatusAsString())
                .add("ResourceStatusReason", resourceStatusReason()).add("ResourceProperties", resourceProperties())
                .add("ClientRequestToken", clientRequestToken()).add("HookType", hookType())
                .add("HookStatus", hookStatusAsString()).add("HookStatusReason", hookStatusReason())
                .add("HookInvocationPoint", hookInvocationPointAsString()).add("HookFailureMode", hookFailureModeAsString())
                .add("DetailedStatus", detailedStatusAsString()).add("ValidationFailureMode", validationFailureModeAsString())
                .add("ValidationName", validationName()).add("ValidationStatus", validationStatusAsString())
                .add("ValidationStatusReason", validationStatusReason()).add("ValidationPath", validationPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "OperationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "OperationStatus":
            return Optional.ofNullable(clazz.cast(operationStatusAsString()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "LogicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ResourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatusAsString()));
        case "ResourceStatusReason":
            return Optional.ofNullable(clazz.cast(resourceStatusReason()));
        case "ResourceProperties":
            return Optional.ofNullable(clazz.cast(resourceProperties()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "HookType":
            return Optional.ofNullable(clazz.cast(hookType()));
        case "HookStatus":
            return Optional.ofNullable(clazz.cast(hookStatusAsString()));
        case "HookStatusReason":
            return Optional.ofNullable(clazz.cast(hookStatusReason()));
        case "HookInvocationPoint":
            return Optional.ofNullable(clazz.cast(hookInvocationPointAsString()));
        case "HookFailureMode":
            return Optional.ofNullable(clazz.cast(hookFailureModeAsString()));
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatusAsString()));
        case "ValidationFailureMode":
            return Optional.ofNullable(clazz.cast(validationFailureModeAsString()));
        case "ValidationName":
            return Optional.ofNullable(clazz.cast(validationName()));
        case "ValidationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        case "ValidationStatusReason":
            return Optional.ofNullable(clazz.cast(validationStatusReason()));
        case "ValidationPath":
            return Optional.ofNullable(clazz.cast(validationPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventId", EVENT_ID_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        map.put("OperationType", OPERATION_TYPE_FIELD);
        map.put("OperationStatus", OPERATION_STATUS_FIELD);
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("PhysicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ResourceStatus", RESOURCE_STATUS_FIELD);
        map.put("ResourceStatusReason", RESOURCE_STATUS_REASON_FIELD);
        map.put("ResourceProperties", RESOURCE_PROPERTIES_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("HookType", HOOK_TYPE_FIELD);
        map.put("HookStatus", HOOK_STATUS_FIELD);
        map.put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
        map.put("HookInvocationPoint", HOOK_INVOCATION_POINT_FIELD);
        map.put("HookFailureMode", HOOK_FAILURE_MODE_FIELD);
        map.put("DetailedStatus", DETAILED_STATUS_FIELD);
        map.put("ValidationFailureMode", VALIDATION_FAILURE_MODE_FIELD);
        map.put("ValidationName", VALIDATION_NAME_FIELD);
        map.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        map.put("ValidationStatusReason", VALIDATION_STATUS_REASON_FIELD);
        map.put("ValidationPath", VALIDATION_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OperationEvent, T> g) {
        return obj -> g.apply((OperationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationEvent> {
        /**
         * <p>
         * A unique identifier for this event.
         * </p>
         * 
         * @param eventId
         *        A unique identifier for this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The unique ID name of the instance of the stack.
         * </p>
         * 
         * @param stackId
         *        The unique ID name of the instance of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The unique identifier of the operation this event belongs to.
         * </p>
         * 
         * @param operationId
         *        The unique identifier of the operation this event belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The current status of the operation.
         * </p>
         * 
         * @param operationStatus
         *        The current status of the operation.
         * @see BeaconStackOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BeaconStackOperationStatus
         */
        Builder operationStatus(String operationStatus);

        /**
         * <p>
         * The current status of the operation.
         * </p>
         * 
         * @param operationStatus
         *        The current status of the operation.
         * @see BeaconStackOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BeaconStackOperationStatus
         */
        Builder operationStatus(BeaconStackOperationStatus operationStatus);

        /**
         * <p>
         * The type of event.
         * </p>
         * 
         * @param eventType
         *        The type of event.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of event.
         * </p>
         * 
         * @param eventType
         *        The type of event.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The logical name of the resource as specified in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource as specified in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier that corresponds to a physical instance ID of a resource.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier that corresponds to a physical instance ID of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * Type of resource.
         * </p>
         * 
         * @param resourceType
         *        Type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Time the status was updated.
         * </p>
         * 
         * @param timestamp
         *        Time the status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The time when the event started.
         * </p>
         * 
         * @param startTime
         *        The time when the event started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the event ended.
         * </p>
         * 
         * @param endTime
         *        The time when the event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * Success or failure message associated with the resource.
         * </p>
         * 
         * @param resourceStatusReason
         *        Success or failure message associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatusReason(String resourceStatusReason);

        /**
         * <p>
         * The properties used to create the resource.
         * </p>
         * 
         * @param resourceProperties
         *        The properties used to create the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceProperties(String resourceProperties);

        /**
         * <p>
         * A unique identifier for the request that initiated this operation.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for the request that initiated this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The type name of the Hook that was invoked.
         * </p>
         * 
         * @param hookType
         *        The type name of the Hook that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookType(String hookType);

        /**
         * <p>
         * The status of the Hook invocation.
         * </p>
         * 
         * @param hookStatus
         *        The status of the Hook invocation.
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder hookStatus(String hookStatus);

        /**
         * <p>
         * The status of the Hook invocation.
         * </p>
         * 
         * @param hookStatus
         *        The status of the Hook invocation.
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder hookStatus(HookStatus hookStatus);

        /**
         * <p>
         * Additional information about the Hook status.
         * </p>
         * 
         * @param hookStatusReason
         *        Additional information about the Hook status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookStatusReason(String hookStatusReason);

        /**
         * <p>
         * The point in the operation lifecycle when the Hook was invoked.
         * </p>
         * 
         * @param hookInvocationPoint
         *        The point in the operation lifecycle when the Hook was invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder hookInvocationPoint(String hookInvocationPoint);

        /**
         * <p>
         * The point in the operation lifecycle when the Hook was invoked.
         * </p>
         * 
         * @param hookInvocationPoint
         *        The point in the operation lifecycle when the Hook was invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder hookInvocationPoint(HookInvocationPoint hookInvocationPoint);

        /**
         * <p>
         * Specifies how Hook failures are handled.
         * </p>
         * 
         * @param hookFailureMode
         *        Specifies how Hook failures are handled.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder hookFailureMode(String hookFailureMode);

        /**
         * <p>
         * Specifies how Hook failures are handled.
         * </p>
         * 
         * @param hookFailureMode
         *        Specifies how Hook failures are handled.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder hookFailureMode(HookFailureMode hookFailureMode);

        /**
         * <p>
         * Additional status information about the operation.
         * </p>
         * 
         * @param detailedStatus
         *        Additional status information about the operation.
         * @see DetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailedStatus
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * Additional status information about the operation.
         * </p>
         * 
         * @param detailedStatus
         *        Additional status information about the operation.
         * @see DetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailedStatus
         */
        Builder detailedStatus(DetailedStatus detailedStatus);

        /**
         * <p>
         * Specifies how validation failures are handled.
         * </p>
         * 
         * @param validationFailureMode
         *        Specifies how validation failures are handled.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder validationFailureMode(String validationFailureMode);

        /**
         * <p>
         * Specifies how validation failures are handled.
         * </p>
         * 
         * @param validationFailureMode
         *        Specifies how validation failures are handled.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder validationFailureMode(HookFailureMode validationFailureMode);

        /**
         * <p>
         * The name of the validation that was performed.
         * </p>
         * 
         * @param validationName
         *        The name of the validation that was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationName(String validationName);

        /**
         * <p>
         * The status of the validation.
         * </p>
         * 
         * @param validationStatus
         *        The status of the validation.
         * @see ValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * The status of the validation.
         * </p>
         * 
         * @param validationStatus
         *        The status of the validation.
         * @see ValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationStatus
         */
        Builder validationStatus(ValidationStatus validationStatus);

        /**
         * <p>
         * Additional information about the validation status.
         * </p>
         * 
         * @param validationStatusReason
         *        Additional information about the validation status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatusReason(String validationStatusReason);

        /**
         * <p>
         * The path within the resource where the validation was applied.
         * </p>
         * 
         * @param validationPath
         *        The path within the resource where the validation was applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationPath(String validationPath);
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String stackId;

        private String operationId;

        private String operationType;

        private String operationStatus;

        private String eventType;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private Instant timestamp;

        private Instant startTime;

        private Instant endTime;

        private String resourceStatus;

        private String resourceStatusReason;

        private String resourceProperties;

        private String clientRequestToken;

        private String hookType;

        private String hookStatus;

        private String hookStatusReason;

        private String hookInvocationPoint;

        private String hookFailureMode;

        private String detailedStatus;

        private String validationFailureMode;

        private String validationName;

        private String validationStatus;

        private String validationStatusReason;

        private String validationPath;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationEvent model) {
            eventId(model.eventId);
            stackId(model.stackId);
            operationId(model.operationId);
            operationType(model.operationType);
            operationStatus(model.operationStatus);
            eventType(model.eventType);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceType(model.resourceType);
            timestamp(model.timestamp);
            startTime(model.startTime);
            endTime(model.endTime);
            resourceStatus(model.resourceStatus);
            resourceStatusReason(model.resourceStatusReason);
            resourceProperties(model.resourceProperties);
            clientRequestToken(model.clientRequestToken);
            hookType(model.hookType);
            hookStatus(model.hookStatus);
            hookStatusReason(model.hookStatusReason);
            hookInvocationPoint(model.hookInvocationPoint);
            hookFailureMode(model.hookFailureMode);
            detailedStatus(model.detailedStatus);
            validationFailureMode(model.validationFailureMode);
            validationName(model.validationName);
            validationStatus(model.validationStatus);
            validationStatusReason(model.validationStatusReason);
            validationPath(model.validationPath);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final String getOperationStatus() {
            return operationStatus;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(BeaconStackOperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getResourceStatusReason() {
            return resourceStatusReason;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final String getResourceProperties() {
            return resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getHookType() {
            return hookType;
        }

        public final void setHookType(String hookType) {
            this.hookType = hookType;
        }

        @Override
        public final Builder hookType(String hookType) {
            this.hookType = hookType;
            return this;
        }

        public final String getHookStatus() {
            return hookStatus;
        }

        public final void setHookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
        }

        @Override
        public final Builder hookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
            return this;
        }

        @Override
        public final Builder hookStatus(HookStatus hookStatus) {
            this.hookStatus(hookStatus == null ? null : hookStatus.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public final String getHookInvocationPoint() {
            return hookInvocationPoint;
        }

        public final void setHookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
        }

        @Override
        public final Builder hookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
            return this;
        }

        @Override
        public final Builder hookInvocationPoint(HookInvocationPoint hookInvocationPoint) {
            this.hookInvocationPoint(hookInvocationPoint == null ? null : hookInvocationPoint.toString());
            return this;
        }

        public final String getHookFailureMode() {
            return hookFailureMode;
        }

        public final void setHookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
        }

        @Override
        public final Builder hookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
            return this;
        }

        @Override
        public final Builder hookFailureMode(HookFailureMode hookFailureMode) {
            this.hookFailureMode(hookFailureMode == null ? null : hookFailureMode.toString());
            return this;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        @Override
        public final Builder detailedStatus(DetailedStatus detailedStatus) {
            this.detailedStatus(detailedStatus == null ? null : detailedStatus.toString());
            return this;
        }

        public final String getValidationFailureMode() {
            return validationFailureMode;
        }

        public final void setValidationFailureMode(String validationFailureMode) {
            this.validationFailureMode = validationFailureMode;
        }

        @Override
        public final Builder validationFailureMode(String validationFailureMode) {
            this.validationFailureMode = validationFailureMode;
            return this;
        }

        @Override
        public final Builder validationFailureMode(HookFailureMode validationFailureMode) {
            this.validationFailureMode(validationFailureMode == null ? null : validationFailureMode.toString());
            return this;
        }

        public final String getValidationName() {
            return validationName;
        }

        public final void setValidationName(String validationName) {
            this.validationName = validationName;
        }

        @Override
        public final Builder validationName(String validationName) {
            this.validationName = validationName;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(ValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getValidationStatusReason() {
            return validationStatusReason;
        }

        public final void setValidationStatusReason(String validationStatusReason) {
            this.validationStatusReason = validationStatusReason;
        }

        @Override
        public final Builder validationStatusReason(String validationStatusReason) {
            this.validationStatusReason = validationStatusReason;
            return this;
        }

        public final String getValidationPath() {
            return validationPath;
        }

        public final void setValidationPath(String validationPath) {
            this.validationPath = validationPath;
        }

        @Override
        public final Builder validationPath(String validationPath) {
            this.validationPath = validationPath;
            return this;
        }

        @Override
        public OperationEvent build() {
            return new OperationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
