/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackResourcesResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStackResourcesResponse> {
    private static final SdkField<List<StackResourceSummary>> STACK_RESOURCE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackResourceSummaries").getter(ListStackResourcesResponse.getter(ListStackResourcesResponse::stackResourceSummaries)).setter(ListStackResourcesResponse.setter(Builder::stackResourceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStackResourcesResponse.getter(ListStackResourcesResponse::nextToken)).setter(ListStackResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStackResourcesResponse.memberNameToFieldInitializer();
    private final List<StackResourceSummary> stackResourceSummaries;
    private final String nextToken;

    private ListStackResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceSummaries = builder.stackResourceSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStackResourceSummaries() {
        return this.stackResourceSummaries != null && !(this.stackResourceSummaries instanceof SdkAutoConstructList);
    }

    public final List<StackResourceSummary> stackResourceSummaries() {
        return this.stackResourceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackResourceSummaries() ? this.stackResourceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesResponse)) {
            return false;
        }
        ListStackResourcesResponse other = (ListStackResourcesResponse)((Object)obj);
        return this.hasStackResourceSummaries() == other.hasStackResourceSummaries() && Objects.equals(this.stackResourceSummaries(), other.stackResourceSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStackResourcesResponse").add("StackResourceSummaries", this.hasStackResourceSummaries() ? this.stackResourceSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackResourceSummaries": {
                return Optional.ofNullable(clazz.cast(this.stackResourceSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackResourceSummaries", STACK_RESOURCE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStackResourcesResponse, T> g) {
        return obj -> g.apply((ListStackResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackResourceSummary> stackResourceSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackResourcesResponse model) {
            super(model);
            this.stackResourceSummaries(model.stackResourceSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<StackResourceSummary.Builder> getStackResourceSummaries() {
            List<StackResourceSummary.Builder> result = StackResourceSummariesCopier.copyToBuilder(this.stackResourceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackResourceSummaries(Collection<StackResourceSummary.BuilderImpl> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copyFromBuilder(stackResourceSummaries);
        }

        @Override
        public final Builder stackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copy(stackResourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(StackResourceSummary ... stackResourceSummaries) {
            this.stackResourceSummaries(Arrays.asList(stackResourceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(Consumer<StackResourceSummary.Builder> ... stackResourceSummaries) {
            this.stackResourceSummaries(Stream.of(stackResourceSummaries).map(c -> (StackResourceSummary)((StackResourceSummary.Builder)StackResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStackResourcesResponse build() {
            return new ListStackResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStackResourcesResponse> {
        public Builder stackResourceSummaries(Collection<StackResourceSummary> var1);

        public Builder stackResourceSummaries(StackResourceSummary ... var1);

        public Builder stackResourceSummaries(Consumer<StackResourceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

