/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.JazzLogicalResourceIdsCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceDefinition;
import software.amazon.awssdk.services.cloudformation.model.ResourceDefinitionsCopier;
import software.amazon.awssdk.services.cloudformation.model.TemplateConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGeneratedTemplateRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, UpdateGeneratedTemplateRequest> {
    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedTemplateName").getter(UpdateGeneratedTemplateRequest.getter(UpdateGeneratedTemplateRequest::generatedTemplateName)).setter(UpdateGeneratedTemplateRequest.setter(Builder::generatedTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build()}).build();
    private static final SdkField<String> NEW_GENERATED_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewGeneratedTemplateName").getter(UpdateGeneratedTemplateRequest.getter(UpdateGeneratedTemplateRequest::newGeneratedTemplateName)).setter(UpdateGeneratedTemplateRequest.setter(Builder::newGeneratedTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGeneratedTemplateName").build()}).build();
    private static final SdkField<List<ResourceDefinition>> ADD_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddResources").getter(UpdateGeneratedTemplateRequest.getter(UpdateGeneratedTemplateRequest::addResources)).setter(UpdateGeneratedTemplateRequest.setter(Builder::addResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveResources").getter(UpdateGeneratedTemplateRequest.getter(UpdateGeneratedTemplateRequest::removeResources)).setter(UpdateGeneratedTemplateRequest.setter(Builder::removeResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REFRESH_ALL_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RefreshAllResources").getter(UpdateGeneratedTemplateRequest.getter(UpdateGeneratedTemplateRequest::refreshAllResources)).setter(UpdateGeneratedTemplateRequest.setter(Builder::refreshAllResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshAllResources").build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateConfiguration").getter(UpdateGeneratedTemplateRequest.getter(UpdateGeneratedTemplateRequest::templateConfiguration)).setter(UpdateGeneratedTemplateRequest.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_TEMPLATE_NAME_FIELD, NEW_GENERATED_TEMPLATE_NAME_FIELD, ADD_RESOURCES_FIELD, REMOVE_RESOURCES_FIELD, REFRESH_ALL_RESOURCES_FIELD, TEMPLATE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGeneratedTemplateRequest.memberNameToFieldInitializer();
    private final String generatedTemplateName;
    private final String newGeneratedTemplateName;
    private final List<ResourceDefinition> addResources;
    private final List<String> removeResources;
    private final Boolean refreshAllResources;
    private final TemplateConfiguration templateConfiguration;

    private UpdateGeneratedTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.generatedTemplateName = builder.generatedTemplateName;
        this.newGeneratedTemplateName = builder.newGeneratedTemplateName;
        this.addResources = builder.addResources;
        this.removeResources = builder.removeResources;
        this.refreshAllResources = builder.refreshAllResources;
        this.templateConfiguration = builder.templateConfiguration;
    }

    public final String generatedTemplateName() {
        return this.generatedTemplateName;
    }

    public final String newGeneratedTemplateName() {
        return this.newGeneratedTemplateName;
    }

    public final boolean hasAddResources() {
        return this.addResources != null && !(this.addResources instanceof SdkAutoConstructList);
    }

    public final List<ResourceDefinition> addResources() {
        return this.addResources;
    }

    public final boolean hasRemoveResources() {
        return this.removeResources != null && !(this.removeResources instanceof SdkAutoConstructList);
    }

    public final List<String> removeResources() {
        return this.removeResources;
    }

    public final Boolean refreshAllResources() {
        return this.refreshAllResources;
    }

    public final TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newGeneratedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddResources() ? this.addResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveResources() ? this.removeResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshAllResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGeneratedTemplateRequest)) {
            return false;
        }
        UpdateGeneratedTemplateRequest other = (UpdateGeneratedTemplateRequest)((Object)obj);
        return Objects.equals(this.generatedTemplateName(), other.generatedTemplateName()) && Objects.equals(this.newGeneratedTemplateName(), other.newGeneratedTemplateName()) && this.hasAddResources() == other.hasAddResources() && Objects.equals(this.addResources(), other.addResources()) && this.hasRemoveResources() == other.hasRemoveResources() && Objects.equals(this.removeResources(), other.removeResources()) && Objects.equals(this.refreshAllResources(), other.refreshAllResources()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGeneratedTemplateRequest").add("GeneratedTemplateName", (Object)this.generatedTemplateName()).add("NewGeneratedTemplateName", (Object)this.newGeneratedTemplateName()).add("AddResources", this.hasAddResources() ? this.addResources() : null).add("RemoveResources", this.hasRemoveResources() ? this.removeResources() : null).add("RefreshAllResources", (Object)this.refreshAllResources()).add("TemplateConfiguration", (Object)this.templateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeneratedTemplateName": {
                return Optional.ofNullable(clazz.cast(this.generatedTemplateName()));
            }
            case "NewGeneratedTemplateName": {
                return Optional.ofNullable(clazz.cast(this.newGeneratedTemplateName()));
            }
            case "AddResources": {
                return Optional.ofNullable(clazz.cast(this.addResources()));
            }
            case "RemoveResources": {
                return Optional.ofNullable(clazz.cast(this.removeResources()));
            }
            case "RefreshAllResources": {
                return Optional.ofNullable(clazz.cast(this.refreshAllResources()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GeneratedTemplateName", GENERATED_TEMPLATE_NAME_FIELD);
        map.put("NewGeneratedTemplateName", NEW_GENERATED_TEMPLATE_NAME_FIELD);
        map.put("AddResources", ADD_RESOURCES_FIELD);
        map.put("RemoveResources", REMOVE_RESOURCES_FIELD);
        map.put("RefreshAllResources", REFRESH_ALL_RESOURCES_FIELD);
        map.put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGeneratedTemplateRequest, T> g) {
        return obj -> g.apply((UpdateGeneratedTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String generatedTemplateName;
        private String newGeneratedTemplateName;
        private List<ResourceDefinition> addResources = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeResources = DefaultSdkAutoConstructList.getInstance();
        private Boolean refreshAllResources;
        private TemplateConfiguration templateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGeneratedTemplateRequest model) {
            super(model);
            this.generatedTemplateName(model.generatedTemplateName);
            this.newGeneratedTemplateName(model.newGeneratedTemplateName);
            this.addResources(model.addResources);
            this.removeResources(model.removeResources);
            this.refreshAllResources(model.refreshAllResources);
            this.templateConfiguration(model.templateConfiguration);
        }

        public final String getGeneratedTemplateName() {
            return this.generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final String getNewGeneratedTemplateName() {
            return this.newGeneratedTemplateName;
        }

        public final void setNewGeneratedTemplateName(String newGeneratedTemplateName) {
            this.newGeneratedTemplateName = newGeneratedTemplateName;
        }

        @Override
        public final Builder newGeneratedTemplateName(String newGeneratedTemplateName) {
            this.newGeneratedTemplateName = newGeneratedTemplateName;
            return this;
        }

        public final List<ResourceDefinition.Builder> getAddResources() {
            List<ResourceDefinition.Builder> result = ResourceDefinitionsCopier.copyToBuilder(this.addResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddResources(Collection<ResourceDefinition.BuilderImpl> addResources) {
            this.addResources = ResourceDefinitionsCopier.copyFromBuilder(addResources);
        }

        @Override
        public final Builder addResources(Collection<ResourceDefinition> addResources) {
            this.addResources = ResourceDefinitionsCopier.copy(addResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(ResourceDefinition ... addResources) {
            this.addResources(Arrays.asList(addResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(Consumer<ResourceDefinition.Builder> ... addResources) {
            this.addResources(Stream.of(addResources).map(c -> (ResourceDefinition)((ResourceDefinition.Builder)ResourceDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveResources() {
            if (this.removeResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeResources;
        }

        public final void setRemoveResources(Collection<String> removeResources) {
            this.removeResources = JazzLogicalResourceIdsCopier.copy(removeResources);
        }

        @Override
        public final Builder removeResources(Collection<String> removeResources) {
            this.removeResources = JazzLogicalResourceIdsCopier.copy(removeResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeResources(String ... removeResources) {
            this.removeResources(Arrays.asList(removeResources));
            return this;
        }

        public final Boolean getRefreshAllResources() {
            return this.refreshAllResources;
        }

        public final void setRefreshAllResources(Boolean refreshAllResources) {
            this.refreshAllResources = refreshAllResources;
        }

        @Override
        public final Builder refreshAllResources(Boolean refreshAllResources) {
            this.refreshAllResources = refreshAllResources;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGeneratedTemplateRequest build() {
            return new UpdateGeneratedTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGeneratedTemplateRequest> {
        public Builder generatedTemplateName(String var1);

        public Builder newGeneratedTemplateName(String var1);

        public Builder addResources(Collection<ResourceDefinition> var1);

        public Builder addResources(ResourceDefinition ... var1);

        public Builder addResources(Consumer<ResourceDefinition.Builder> ... var1);

        public Builder removeResources(Collection<String> var1);

        public Builder removeResources(String ... var1);

        public Builder refreshAllResources(Boolean var1);

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

