/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.DetailedStatus;
import software.amazon.awssdk.services.cloudformation.model.HookFailureMode;
import software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint;
import software.amazon.awssdk.services.cloudformation.model.HookStatus;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackEvent> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(StackEvent.getter(StackEvent::stackId)).setter(StackEvent.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(StackEvent.getter(StackEvent::eventId)).setter(StackEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(StackEvent.getter(StackEvent::stackName)).setter(StackEvent.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalResourceId").getter(StackEvent.getter(StackEvent::logicalResourceId)).setter(StackEvent.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalResourceId").getter(StackEvent.getter(StackEvent::physicalResourceId)).setter(StackEvent.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(StackEvent.getter(StackEvent::resourceType)).setter(StackEvent.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(StackEvent.getter(StackEvent::timestamp)).setter(StackEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatus").getter(StackEvent.getter(StackEvent::resourceStatusAsString)).setter(StackEvent.setter(Builder::resourceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatusReason").getter(StackEvent.getter(StackEvent::resourceStatusReason)).setter(StackEvent.setter(Builder::resourceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatusReason").build()}).build();
    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceProperties").getter(StackEvent.getter(StackEvent::resourceProperties)).setter(StackEvent.setter(Builder::resourceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StackEvent.getter(StackEvent::clientRequestToken)).setter(StackEvent.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<String> HOOK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookType").getter(StackEvent.getter(StackEvent::hookType)).setter(StackEvent.setter(Builder::hookType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookType").build()}).build();
    private static final SdkField<String> HOOK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookStatus").getter(StackEvent.getter(StackEvent::hookStatusAsString)).setter(StackEvent.setter(Builder::hookStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatus").build()}).build();
    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookStatusReason").getter(StackEvent.getter(StackEvent::hookStatusReason)).setter(StackEvent.setter(Builder::hookStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()}).build();
    private static final SdkField<String> HOOK_INVOCATION_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookInvocationPoint").getter(StackEvent.getter(StackEvent::hookInvocationPointAsString)).setter(StackEvent.setter(Builder::hookInvocationPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookInvocationPoint").build()}).build();
    private static final SdkField<String> HOOK_FAILURE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookFailureMode").getter(StackEvent.getter(StackEvent::hookFailureModeAsString)).setter(StackEvent.setter(Builder::hookFailureMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookFailureMode").build()}).build();
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailedStatus").getter(StackEvent.getter(StackEvent::detailedStatusAsString)).setter(StackEvent.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, EVENT_ID_FIELD, STACK_NAME_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TIMESTAMP_FIELD, RESOURCE_STATUS_FIELD, RESOURCE_STATUS_REASON_FIELD, RESOURCE_PROPERTIES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, HOOK_TYPE_FIELD, HOOK_STATUS_FIELD, HOOK_STATUS_REASON_FIELD, HOOK_INVOCATION_POINT_FIELD, HOOK_FAILURE_MODE_FIELD, DETAILED_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StackEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final String eventId;
    private final String stackName;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Instant timestamp;
    private final String resourceStatus;
    private final String resourceStatusReason;
    private final String resourceProperties;
    private final String clientRequestToken;
    private final String hookType;
    private final String hookStatus;
    private final String hookStatusReason;
    private final String hookInvocationPoint;
    private final String hookFailureMode;
    private final String detailedStatus;

    private StackEvent(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.eventId = builder.eventId;
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.resourceProperties = builder.resourceProperties;
        this.clientRequestToken = builder.clientRequestToken;
        this.hookType = builder.hookType;
        this.hookStatus = builder.hookStatus;
        this.hookStatusReason = builder.hookStatusReason;
        this.hookInvocationPoint = builder.hookInvocationPoint;
        this.hookFailureMode = builder.hookFailureMode;
        this.detailedStatus = builder.detailedStatus;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public final String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public final String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public final String resourceProperties() {
        return this.resourceProperties;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String hookType() {
        return this.hookType;
    }

    public final HookStatus hookStatus() {
        return HookStatus.fromValue(this.hookStatus);
    }

    public final String hookStatusAsString() {
        return this.hookStatus;
    }

    public final String hookStatusReason() {
        return this.hookStatusReason;
    }

    public final HookInvocationPoint hookInvocationPoint() {
        return HookInvocationPoint.fromValue(this.hookInvocationPoint);
    }

    public final String hookInvocationPointAsString() {
        return this.hookInvocationPoint;
    }

    public final HookFailureMode hookFailureMode() {
        return HookFailureMode.fromValue(this.hookFailureMode);
    }

    public final String hookFailureModeAsString() {
        return this.hookFailureMode;
    }

    public final DetailedStatus detailedStatus() {
        return DetailedStatus.fromValue(this.detailedStatus);
    }

    public final String detailedStatusAsString() {
        return this.detailedStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookInvocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookFailureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackEvent)) {
            return false;
        }
        StackEvent other = (StackEvent)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.resourceStatusReason(), other.resourceStatusReason()) && Objects.equals(this.resourceProperties(), other.resourceProperties()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.hookType(), other.hookType()) && Objects.equals(this.hookStatusAsString(), other.hookStatusAsString()) && Objects.equals(this.hookStatusReason(), other.hookStatusReason()) && Objects.equals(this.hookInvocationPointAsString(), other.hookInvocationPointAsString()) && Objects.equals(this.hookFailureModeAsString(), other.hookFailureModeAsString()) && Objects.equals(this.detailedStatusAsString(), other.detailedStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StackEvent").add("StackId", (Object)this.stackId()).add("EventId", (Object)this.eventId()).add("StackName", (Object)this.stackName()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("Timestamp", (Object)this.timestamp()).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ResourceStatusReason", (Object)this.resourceStatusReason()).add("ResourceProperties", (Object)this.resourceProperties()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("HookType", (Object)this.hookType()).add("HookStatus", (Object)this.hookStatusAsString()).add("HookStatusReason", (Object)this.hookStatusReason()).add("HookInvocationPoint", (Object)this.hookInvocationPointAsString()).add("HookFailureMode", (Object)this.hookFailureModeAsString()).add("DetailedStatus", (Object)this.detailedStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "ResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusAsString()));
            }
            case "ResourceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusReason()));
            }
            case "ResourceProperties": {
                return Optional.ofNullable(clazz.cast(this.resourceProperties()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "HookType": {
                return Optional.ofNullable(clazz.cast(this.hookType()));
            }
            case "HookStatus": {
                return Optional.ofNullable(clazz.cast(this.hookStatusAsString()));
            }
            case "HookStatusReason": {
                return Optional.ofNullable(clazz.cast(this.hookStatusReason()));
            }
            case "HookInvocationPoint": {
                return Optional.ofNullable(clazz.cast(this.hookInvocationPointAsString()));
            }
            case "HookFailureMode": {
                return Optional.ofNullable(clazz.cast(this.hookFailureModeAsString()));
            }
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("EventId", EVENT_ID_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("PhysicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("ResourceStatus", RESOURCE_STATUS_FIELD);
        map.put("ResourceStatusReason", RESOURCE_STATUS_REASON_FIELD);
        map.put("ResourceProperties", RESOURCE_PROPERTIES_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("HookType", HOOK_TYPE_FIELD);
        map.put("HookStatus", HOOK_STATUS_FIELD);
        map.put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
        map.put("HookInvocationPoint", HOOK_INVOCATION_POINT_FIELD);
        map.put("HookFailureMode", HOOK_FAILURE_MODE_FIELD);
        map.put("DetailedStatus", DETAILED_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StackEvent, T> g) {
        return obj -> g.apply((StackEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String eventId;
        private String stackName;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Instant timestamp;
        private String resourceStatus;
        private String resourceStatusReason;
        private String resourceProperties;
        private String clientRequestToken;
        private String hookType;
        private String hookStatus;
        private String hookStatusReason;
        private String hookInvocationPoint;
        private String hookFailureMode;
        private String detailedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StackEvent model) {
            this.stackId(model.stackId);
            this.eventId(model.eventId);
            this.stackName(model.stackName);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.timestamp(model.timestamp);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
            this.resourceProperties(model.resourceProperties);
            this.clientRequestToken(model.clientRequestToken);
            this.hookType(model.hookType);
            this.hookStatus(model.hookStatus);
            this.hookStatusReason(model.hookStatusReason);
            this.hookInvocationPoint(model.hookInvocationPoint);
            this.hookFailureMode(model.hookFailureMode);
            this.detailedStatus(model.detailedStatus);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final String getResourceProperties() {
            return this.resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getHookType() {
            return this.hookType;
        }

        public final void setHookType(String hookType) {
            this.hookType = hookType;
        }

        @Override
        public final Builder hookType(String hookType) {
            this.hookType = hookType;
            return this;
        }

        public final String getHookStatus() {
            return this.hookStatus;
        }

        public final void setHookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
        }

        @Override
        public final Builder hookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
            return this;
        }

        @Override
        public final Builder hookStatus(HookStatus hookStatus) {
            this.hookStatus(hookStatus == null ? null : hookStatus.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return this.hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public final String getHookInvocationPoint() {
            return this.hookInvocationPoint;
        }

        public final void setHookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
        }

        @Override
        public final Builder hookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
            return this;
        }

        @Override
        public final Builder hookInvocationPoint(HookInvocationPoint hookInvocationPoint) {
            this.hookInvocationPoint(hookInvocationPoint == null ? null : hookInvocationPoint.toString());
            return this;
        }

        public final String getHookFailureMode() {
            return this.hookFailureMode;
        }

        public final void setHookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
        }

        @Override
        public final Builder hookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
            return this;
        }

        @Override
        public final Builder hookFailureMode(HookFailureMode hookFailureMode) {
            this.hookFailureMode(hookFailureMode == null ? null : hookFailureMode.toString());
            return this;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        @Override
        public final Builder detailedStatus(DetailedStatus detailedStatus) {
            this.detailedStatus(detailedStatus == null ? null : detailedStatus.toString());
            return this;
        }

        public StackEvent build() {
            return new StackEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackEvent> {
        public Builder stackId(String var1);

        public Builder eventId(String var1);

        public Builder stackName(String var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder timestamp(Instant var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);

        public Builder resourceProperties(String var1);

        public Builder clientRequestToken(String var1);

        public Builder hookType(String var1);

        public Builder hookStatus(String var1);

        public Builder hookStatus(HookStatus var1);

        public Builder hookStatusReason(String var1);

        public Builder hookInvocationPoint(String var1);

        public Builder hookInvocationPoint(HookInvocationPoint var1);

        public Builder hookFailureMode(String var1);

        public Builder hookFailureMode(HookFailureMode var1);

        public Builder detailedStatus(String var1);

        public Builder detailedStatus(DetailedStatus var1);
    }
}

