/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.DeletionMode;
import software.amazon.awssdk.services.cloudformation.model.RetainResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteStackRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, DeleteStackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(DeleteStackRequest.getter(DeleteStackRequest::stackName)).setter(DeleteStackRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<List<String>> RETAIN_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RetainResources").getter(DeleteStackRequest.getter(DeleteStackRequest::retainResources)).setter(DeleteStackRequest.setter(Builder::retainResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(DeleteStackRequest.getter(DeleteStackRequest::roleARN)).setter(DeleteStackRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(DeleteStackRequest.getter(DeleteStackRequest::clientRequestToken)).setter(DeleteStackRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<String> DELETION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionMode").getter(DeleteStackRequest.getter(DeleteStackRequest::deletionModeAsString)).setter(DeleteStackRequest.setter(Builder::deletionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, RETAIN_RESOURCES_FIELD, ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DELETION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteStackRequest.memberNameToFieldInitializer();
    private final String stackName;
    private final List<String> retainResources;
    private final String roleARN;
    private final String clientRequestToken;
    private final String deletionMode;

    private DeleteStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.retainResources = builder.retainResources;
        this.roleARN = builder.roleARN;
        this.clientRequestToken = builder.clientRequestToken;
        this.deletionMode = builder.deletionMode;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final boolean hasRetainResources() {
        return this.retainResources != null && !(this.retainResources instanceof SdkAutoConstructList);
    }

    public final List<String> retainResources() {
        return this.retainResources;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final DeletionMode deletionMode() {
        return DeletionMode.fromValue(this.deletionMode);
    }

    public final String deletionModeAsString() {
        return this.deletionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetainResources() ? this.retainResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStackRequest)) {
            return false;
        }
        DeleteStackRequest other = (DeleteStackRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && this.hasRetainResources() == other.hasRetainResources() && Objects.equals(this.retainResources(), other.retainResources()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.deletionModeAsString(), other.deletionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteStackRequest").add("StackName", (Object)this.stackName()).add("RetainResources", this.hasRetainResources() ? this.retainResources() : null).add("RoleARN", (Object)this.roleARN()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("DeletionMode", (Object)this.deletionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "RetainResources": {
                return Optional.ofNullable(clazz.cast(this.retainResources()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "DeletionMode": {
                return Optional.ofNullable(clazz.cast(this.deletionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("RetainResources", RETAIN_RESOURCES_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("DeletionMode", DELETION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteStackRequest, T> g) {
        return obj -> g.apply((DeleteStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private List<String> retainResources = DefaultSdkAutoConstructList.getInstance();
        private String roleARN;
        private String clientRequestToken;
        private String deletionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStackRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.retainResources(model.retainResources);
            this.roleARN(model.roleARN);
            this.clientRequestToken(model.clientRequestToken);
            this.deletionMode(model.deletionMode);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final Collection<String> getRetainResources() {
            if (this.retainResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.retainResources;
        }

        public final void setRetainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
        }

        @Override
        public final Builder retainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainResources(String ... retainResources) {
            this.retainResources(Arrays.asList(retainResources));
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getDeletionMode() {
            return this.deletionMode;
        }

        public final void setDeletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
        }

        @Override
        public final Builder deletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
            return this;
        }

        @Override
        public final Builder deletionMode(DeletionMode deletionMode) {
            this.deletionMode(deletionMode == null ? null : deletionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStackRequest build() {
            return new DeleteStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteStackRequest> {
        public Builder stackName(String var1);

        public Builder retainResources(Collection<String> var1);

        public Builder retainResources(String ... var1);

        public Builder roleARN(String var1);

        public Builder clientRequestToken(String var1);

        public Builder deletionMode(String var1);

        public Builder deletionMode(DeletionMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

