/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.ConcurrencyMode;
import software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType;
import software.amazon.awssdk.services.cloudformation.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetOperationPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSetOperationPreferences> {
    private static final SdkField<String> REGION_CONCURRENCY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionConcurrencyType").getter(StackSetOperationPreferences.getter(StackSetOperationPreferences::regionConcurrencyTypeAsString)).setter(StackSetOperationPreferences.setter(Builder::regionConcurrencyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionConcurrencyType").build()}).build();
    private static final SdkField<List<String>> REGION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionOrder").getter(StackSetOperationPreferences.getter(StackSetOperationPreferences::regionOrder)).setter(StackSetOperationPreferences.setter(Builder::regionOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> FAILURE_TOLERANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureToleranceCount").getter(StackSetOperationPreferences.getter(StackSetOperationPreferences::failureToleranceCount)).setter(StackSetOperationPreferences.setter(Builder::failureToleranceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureToleranceCount").build()}).build();
    private static final SdkField<Integer> FAILURE_TOLERANCE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureTolerancePercentage").getter(StackSetOperationPreferences.getter(StackSetOperationPreferences::failureTolerancePercentage)).setter(StackSetOperationPreferences.setter(Builder::failureTolerancePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureTolerancePercentage").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentCount").getter(StackSetOperationPreferences.getter(StackSetOperationPreferences::maxConcurrentCount)).setter(StackSetOperationPreferences.setter(Builder::maxConcurrentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentCount").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentPercentage").getter(StackSetOperationPreferences.getter(StackSetOperationPreferences::maxConcurrentPercentage)).setter(StackSetOperationPreferences.setter(Builder::maxConcurrentPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentPercentage").build()}).build();
    private static final SdkField<String> CONCURRENCY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConcurrencyMode").getter(StackSetOperationPreferences.getter(StackSetOperationPreferences::concurrencyModeAsString)).setter(StackSetOperationPreferences.setter(Builder::concurrencyMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConcurrencyMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_CONCURRENCY_TYPE_FIELD, REGION_ORDER_FIELD, FAILURE_TOLERANCE_COUNT_FIELD, FAILURE_TOLERANCE_PERCENTAGE_FIELD, MAX_CONCURRENT_COUNT_FIELD, MAX_CONCURRENT_PERCENTAGE_FIELD, CONCURRENCY_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionConcurrencyType;
    private final List<String> regionOrder;
    private final Integer failureToleranceCount;
    private final Integer failureTolerancePercentage;
    private final Integer maxConcurrentCount;
    private final Integer maxConcurrentPercentage;
    private final String concurrencyMode;

    private StackSetOperationPreferences(BuilderImpl builder) {
        this.regionConcurrencyType = builder.regionConcurrencyType;
        this.regionOrder = builder.regionOrder;
        this.failureToleranceCount = builder.failureToleranceCount;
        this.failureTolerancePercentage = builder.failureTolerancePercentage;
        this.maxConcurrentCount = builder.maxConcurrentCount;
        this.maxConcurrentPercentage = builder.maxConcurrentPercentage;
        this.concurrencyMode = builder.concurrencyMode;
    }

    public final RegionConcurrencyType regionConcurrencyType() {
        return RegionConcurrencyType.fromValue(this.regionConcurrencyType);
    }

    public final String regionConcurrencyTypeAsString() {
        return this.regionConcurrencyType;
    }

    public final boolean hasRegionOrder() {
        return this.regionOrder != null && !(this.regionOrder instanceof SdkAutoConstructList);
    }

    public final List<String> regionOrder() {
        return this.regionOrder;
    }

    public final Integer failureToleranceCount() {
        return this.failureToleranceCount;
    }

    public final Integer failureTolerancePercentage() {
        return this.failureTolerancePercentage;
    }

    public final Integer maxConcurrentCount() {
        return this.maxConcurrentCount;
    }

    public final Integer maxConcurrentPercentage() {
        return this.maxConcurrentPercentage;
    }

    public final ConcurrencyMode concurrencyMode() {
        return ConcurrencyMode.fromValue(this.concurrencyMode);
    }

    public final String concurrencyModeAsString() {
        return this.concurrencyMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionConcurrencyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionOrder() ? this.regionOrder() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureToleranceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTolerancePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrencyModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationPreferences)) {
            return false;
        }
        StackSetOperationPreferences other = (StackSetOperationPreferences)obj;
        return Objects.equals(this.regionConcurrencyTypeAsString(), other.regionConcurrencyTypeAsString()) && this.hasRegionOrder() == other.hasRegionOrder() && Objects.equals(this.regionOrder(), other.regionOrder()) && Objects.equals(this.failureToleranceCount(), other.failureToleranceCount()) && Objects.equals(this.failureTolerancePercentage(), other.failureTolerancePercentage()) && Objects.equals(this.maxConcurrentCount(), other.maxConcurrentCount()) && Objects.equals(this.maxConcurrentPercentage(), other.maxConcurrentPercentage()) && Objects.equals(this.concurrencyModeAsString(), other.concurrencyModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StackSetOperationPreferences").add("RegionConcurrencyType", (Object)this.regionConcurrencyTypeAsString()).add("RegionOrder", this.hasRegionOrder() ? this.regionOrder() : null).add("FailureToleranceCount", (Object)this.failureToleranceCount()).add("FailureTolerancePercentage", (Object)this.failureTolerancePercentage()).add("MaxConcurrentCount", (Object)this.maxConcurrentCount()).add("MaxConcurrentPercentage", (Object)this.maxConcurrentPercentage()).add("ConcurrencyMode", (Object)this.concurrencyModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionConcurrencyType": {
                return Optional.ofNullable(clazz.cast(this.regionConcurrencyTypeAsString()));
            }
            case "RegionOrder": {
                return Optional.ofNullable(clazz.cast(this.regionOrder()));
            }
            case "FailureToleranceCount": {
                return Optional.ofNullable(clazz.cast(this.failureToleranceCount()));
            }
            case "FailureTolerancePercentage": {
                return Optional.ofNullable(clazz.cast(this.failureTolerancePercentage()));
            }
            case "MaxConcurrentCount": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentCount()));
            }
            case "MaxConcurrentPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentPercentage()));
            }
            case "ConcurrencyMode": {
                return Optional.ofNullable(clazz.cast(this.concurrencyModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetOperationPreferences, T> g) {
        return obj -> g.apply((StackSetOperationPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionConcurrencyType;
        private List<String> regionOrder = DefaultSdkAutoConstructList.getInstance();
        private Integer failureToleranceCount;
        private Integer failureTolerancePercentage;
        private Integer maxConcurrentCount;
        private Integer maxConcurrentPercentage;
        private String concurrencyMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationPreferences model) {
            this.regionConcurrencyType(model.regionConcurrencyType);
            this.regionOrder(model.regionOrder);
            this.failureToleranceCount(model.failureToleranceCount);
            this.failureTolerancePercentage(model.failureTolerancePercentage);
            this.maxConcurrentCount(model.maxConcurrentCount);
            this.maxConcurrentPercentage(model.maxConcurrentPercentage);
            this.concurrencyMode(model.concurrencyMode);
        }

        public final String getRegionConcurrencyType() {
            return this.regionConcurrencyType;
        }

        public final void setRegionConcurrencyType(String regionConcurrencyType) {
            this.regionConcurrencyType = regionConcurrencyType;
        }

        @Override
        public final Builder regionConcurrencyType(String regionConcurrencyType) {
            this.regionConcurrencyType = regionConcurrencyType;
            return this;
        }

        @Override
        public final Builder regionConcurrencyType(RegionConcurrencyType regionConcurrencyType) {
            this.regionConcurrencyType(regionConcurrencyType == null ? null : regionConcurrencyType.toString());
            return this;
        }

        public final Collection<String> getRegionOrder() {
            if (this.regionOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionOrder;
        }

        public final void setRegionOrder(Collection<String> regionOrder) {
            this.regionOrder = RegionListCopier.copy(regionOrder);
        }

        @Override
        public final Builder regionOrder(Collection<String> regionOrder) {
            this.regionOrder = RegionListCopier.copy(regionOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionOrder(String ... regionOrder) {
            this.regionOrder(Arrays.asList(regionOrder));
            return this;
        }

        public final Integer getFailureToleranceCount() {
            return this.failureToleranceCount;
        }

        public final void setFailureToleranceCount(Integer failureToleranceCount) {
            this.failureToleranceCount = failureToleranceCount;
        }

        @Override
        public final Builder failureToleranceCount(Integer failureToleranceCount) {
            this.failureToleranceCount = failureToleranceCount;
            return this;
        }

        public final Integer getFailureTolerancePercentage() {
            return this.failureTolerancePercentage;
        }

        public final void setFailureTolerancePercentage(Integer failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
        }

        @Override
        public final Builder failureTolerancePercentage(Integer failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
            return this;
        }

        public final Integer getMaxConcurrentCount() {
            return this.maxConcurrentCount;
        }

        public final void setMaxConcurrentCount(Integer maxConcurrentCount) {
            this.maxConcurrentCount = maxConcurrentCount;
        }

        @Override
        public final Builder maxConcurrentCount(Integer maxConcurrentCount) {
            this.maxConcurrentCount = maxConcurrentCount;
            return this;
        }

        public final Integer getMaxConcurrentPercentage() {
            return this.maxConcurrentPercentage;
        }

        public final void setMaxConcurrentPercentage(Integer maxConcurrentPercentage) {
            this.maxConcurrentPercentage = maxConcurrentPercentage;
        }

        @Override
        public final Builder maxConcurrentPercentage(Integer maxConcurrentPercentage) {
            this.maxConcurrentPercentage = maxConcurrentPercentage;
            return this;
        }

        public final String getConcurrencyMode() {
            return this.concurrencyMode;
        }

        public final void setConcurrencyMode(String concurrencyMode) {
            this.concurrencyMode = concurrencyMode;
        }

        @Override
        public final Builder concurrencyMode(String concurrencyMode) {
            this.concurrencyMode = concurrencyMode;
            return this;
        }

        @Override
        public final Builder concurrencyMode(ConcurrencyMode concurrencyMode) {
            this.concurrencyMode(concurrencyMode == null ? null : concurrencyMode.toString());
            return this;
        }

        public StackSetOperationPreferences build() {
            return new StackSetOperationPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSetOperationPreferences> {
        public Builder regionConcurrencyType(String var1);

        public Builder regionConcurrencyType(RegionConcurrencyType var1);

        public Builder regionOrder(Collection<String> var1);

        public Builder regionOrder(String ... var1);

        public Builder failureToleranceCount(Integer var1);

        public Builder failureTolerancePercentage(Integer var1);

        public Builder maxConcurrentCount(Integer var1);

        public Builder maxConcurrentPercentage(Integer var1);

        public Builder concurrencyMode(String var1);

        public Builder concurrencyMode(ConcurrencyMode var1);
    }
}

