/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChangeSetType {
    CREATE("CREATE"),
    UPDATE("UPDATE"),
    IMPORT("IMPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChangeSetType> VALUE_MAP;
    private final String value;

    private ChangeSetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChangeSetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChangeSetType> knownValues() {
        EnumSet<ChangeSetType> knownValues = EnumSet.allOf(ChangeSetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChangeSetType.class, ChangeSetType::toString);
    }
}

