/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceSummary;

public class ListStackInstancesPublisher
implements SdkPublisher<ListStackInstancesResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStackInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStackInstancesPublisher(CloudFormationAsyncClient client, ListStackInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStackInstancesPublisher(CloudFormationAsyncClient client, ListStackInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStackInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStackInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackInstanceSummary> summaries() {
        Function<ListStackInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStackInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStackInstancesResponseFetcher
    implements AsyncPageFetcher<ListStackInstancesResponse> {
        private ListStackInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListStackInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStackInstancesResponse> nextPage(ListStackInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListStackInstancesPublisher.this.client.listStackInstances(ListStackInstancesPublisher.this.firstRequest);
            }
            return ListStackInstancesPublisher.this.client.listStackInstances((ListStackInstancesRequest)((Object)ListStackInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

