/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Output
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Output> {
    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputKey").getter(Output.getter(Output::outputKey)).setter(Output.setter(Builder::outputKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()}).build();
    private static final SdkField<String> OUTPUT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputValue").getter(Output.getter(Output::outputValue)).setter(Output.setter(Builder::outputValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Output.getter(Output::description)).setter(Output.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EXPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportName").getter(Output.getter(Output::exportName)).setter(Output.setter(Builder::exportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_KEY_FIELD, OUTPUT_VALUE_FIELD, DESCRIPTION_FIELD, EXPORT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputKey;
    private final String outputValue;
    private final String description;
    private final String exportName;

    private Output(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
        this.exportName = builder.exportName;
    }

    public final String outputKey() {
        return this.outputKey;
    }

    public final String outputValue() {
        return this.outputValue;
    }

    public final String description() {
        return this.description;
    }

    public final String exportName() {
        return this.exportName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.outputKey(), other.outputKey()) && Objects.equals(this.outputValue(), other.outputValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.exportName(), other.exportName());
    }

    public final String toString() {
        return ToString.builder((String)"Output").add("OutputKey", (Object)this.outputKey()).add("OutputValue", (Object)this.outputValue()).add("Description", (Object)this.description()).add("ExportName", (Object)this.exportName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputKey": {
                return Optional.ofNullable(clazz.cast(this.outputKey()));
            }
            case "OutputValue": {
                return Optional.ofNullable(clazz.cast(this.outputValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExportName": {
                return Optional.ofNullable(clazz.cast(this.exportName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputKey;
        private String outputValue;
        private String description;
        private String exportName;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.outputKey(model.outputKey);
            this.outputValue(model.outputValue);
            this.description(model.description);
            this.exportName(model.exportName);
        }

        public final String getOutputKey() {
            return this.outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return this.outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExportName() {
            return this.exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        public Output build() {
            return new Output(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Output> {
        public Builder outputKey(String var1);

        public Builder outputValue(String var1);

        public Builder description(String var1);

        public Builder exportName(String var1);
    }
}

