/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IdentityProvider {
    AWS_MARKETPLACE("AWS_Marketplace"),
    GIT_HUB("GitHub"),
    BITBUCKET("Bitbucket"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IdentityProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdentityProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IdentityProvider.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdentityProvider> knownValues() {
        return Stream.of(IdentityProvider.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

