/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetStackPolicyRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, SetStackPolicyRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(SetStackPolicyRequest.getter(SetStackPolicyRequest::stackName)).setter(SetStackPolicyRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> STACK_POLICY_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackPolicyBody").getter(SetStackPolicyRequest.getter(SetStackPolicyRequest::stackPolicyBody)).setter(SetStackPolicyRequest.setter(Builder::stackPolicyBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyBody").build()}).build();
    private static final SdkField<String> STACK_POLICY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackPolicyURL").getter(SetStackPolicyRequest.getter(SetStackPolicyRequest::stackPolicyURL)).setter(SetStackPolicyRequest.setter(Builder::stackPolicyURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyURL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, STACK_POLICY_BODY_FIELD, STACK_POLICY_URL_FIELD));
    private final String stackName;
    private final String stackPolicyBody;
    private final String stackPolicyURL;

    private SetStackPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
    }

    public String stackName() {
        return this.stackName;
    }

    public String stackPolicyBody() {
        return this.stackPolicyBody;
    }

    public String stackPolicyURL() {
        return this.stackPolicyURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyURL());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetStackPolicyRequest)) {
            return false;
        }
        SetStackPolicyRequest other = (SetStackPolicyRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackPolicyBody(), other.stackPolicyBody()) && Objects.equals(this.stackPolicyURL(), other.stackPolicyURL());
    }

    public String toString() {
        return ToString.builder((String)"SetStackPolicyRequest").add("StackName", (Object)this.stackName()).add("StackPolicyBody", (Object)this.stackPolicyBody()).add("StackPolicyURL", (Object)this.stackPolicyURL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "StackPolicyBody": {
                return Optional.ofNullable(clazz.cast(this.stackPolicyBody()));
            }
            case "StackPolicyURL": {
                return Optional.ofNullable(clazz.cast(this.stackPolicyURL()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetStackPolicyRequest, T> g) {
        return obj -> g.apply((SetStackPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String stackPolicyBody;
        private String stackPolicyURL;

        private BuilderImpl() {
        }

        private BuilderImpl(SetStackPolicyRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.stackPolicyBody(model.stackPolicyBody);
            this.stackPolicyURL(model.stackPolicyURL);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getStackPolicyBody() {
            return this.stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return this.stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetStackPolicyRequest build() {
            return new SetStackPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetStackPolicyRequest> {
        public Builder stackName(String var1);

        public Builder stackPolicyBody(String var1);

        public Builder stackPolicyURL(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

