/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDrift;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackResourceDriftsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackResourceDriftsResponse> {
    private static final SdkField<List<StackResourceDrift>> STACK_RESOURCE_DRIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackResourceDrifts").getter(DescribeStackResourceDriftsResponse.getter(DescribeStackResourceDriftsResponse::stackResourceDrifts)).setter(DescribeStackResourceDriftsResponse.setter(Builder::stackResourceDrifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDrifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackResourceDrift::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStackResourceDriftsResponse.getter(DescribeStackResourceDriftsResponse::nextToken)).setter(DescribeStackResourceDriftsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCE_DRIFTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StackResourceDrift> stackResourceDrifts;
    private final String nextToken;

    private DescribeStackResourceDriftsResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceDrifts = builder.stackResourceDrifts;
        this.nextToken = builder.nextToken;
    }

    public boolean hasStackResourceDrifts() {
        return this.stackResourceDrifts != null && !(this.stackResourceDrifts instanceof SdkAutoConstructList);
    }

    public List<StackResourceDrift> stackResourceDrifts() {
        return this.stackResourceDrifts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackResourceDrifts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourceDriftsResponse)) {
            return false;
        }
        DescribeStackResourceDriftsResponse other = (DescribeStackResourceDriftsResponse)((Object)obj);
        return Objects.equals(this.stackResourceDrifts(), other.stackResourceDrifts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStackResourceDriftsResponse").add("StackResourceDrifts", this.stackResourceDrifts()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackResourceDrifts": {
                return Optional.ofNullable(clazz.cast(this.stackResourceDrifts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourceDriftsResponse, T> g) {
        return obj -> g.apply((DescribeStackResourceDriftsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackResourceDrift> stackResourceDrifts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourceDriftsResponse model) {
            super(model);
            this.stackResourceDrifts(model.stackResourceDrifts);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackResourceDrift.Builder> getStackResourceDrifts() {
            return this.stackResourceDrifts != null ? (Collection)this.stackResourceDrifts.stream().map(StackResourceDrift::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackResourceDrifts(Collection<StackResourceDrift> stackResourceDrifts) {
            this.stackResourceDrifts = StackResourceDriftsCopier.copy(stackResourceDrifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDrifts(StackResourceDrift ... stackResourceDrifts) {
            this.stackResourceDrifts(Arrays.asList(stackResourceDrifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDrifts(Consumer<StackResourceDrift.Builder> ... stackResourceDrifts) {
            this.stackResourceDrifts(Stream.of(stackResourceDrifts).map(c -> (StackResourceDrift)((StackResourceDrift.Builder)StackResourceDrift.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStackResourceDrifts(Collection<StackResourceDrift.BuilderImpl> stackResourceDrifts) {
            this.stackResourceDrifts = StackResourceDriftsCopier.copyFromBuilder(stackResourceDrifts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeStackResourceDriftsResponse build() {
            return new DescribeStackResourceDriftsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackResourceDriftsResponse> {
        public Builder stackResourceDrifts(Collection<StackResourceDrift> var1);

        public Builder stackResourceDrifts(StackResourceDrift ... var1);

        public Builder stackResourceDrifts(Consumer<StackResourceDrift.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

