/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackResourceDriftsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackResourceDriftsResponse.Builder, DescribeStackResourceDriftsResponse> {
    private static final SdkField<List<StackResourceDrift>> STACK_RESOURCE_DRIFTS_FIELD = SdkField
            .<List<StackResourceDrift>> builder(MarshallingType.LIST)
            .getter(getter(DescribeStackResourceDriftsResponse::stackResourceDrifts))
            .setter(setter(Builder::stackResourceDrifts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDrifts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackResourceDrift> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackResourceDrift::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStackResourceDriftsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCE_DRIFTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StackResourceDrift> stackResourceDrifts;

    private final String nextToken;

    private DescribeStackResourceDriftsResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceDrifts = builder.stackResourceDrifts;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the StackResourceDrifts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStackResourceDrifts() {
        return stackResourceDrifts != null && !(stackResourceDrifts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Drift information for the resources that have been checked for drift in the specified stack. This includes actual
     * and expected configuration values for resources where AWS CloudFormation detects drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackResourceDrifts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Drift information for the resources that have been checked for drift in the specified stack. This
     *         includes actual and expected configuration values for resources where AWS CloudFormation detects
     *         drift.</p>
     *         <p>
     *         For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has
     *         been checked for drift. Resources that have not yet been checked for drift are not included. Resources
     *         that do not currently support drift detection are not checked, and so not included. For a list of
     *         resources that support drift detection, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     *         >Resources that Support Drift Detection</a>.
     */
    public List<StackResourceDrift> stackResourceDrifts() {
        return stackResourceDrifts;
    }

    /**
     * <p>
     * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign that token to the request
     * object's <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign that
     *         token to the request object's <code>NextToken</code> parameter. If the request returns all results,
     *         <code>NextToken</code> is set to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackResourceDrifts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourceDriftsResponse)) {
            return false;
        }
        DescribeStackResourceDriftsResponse other = (DescribeStackResourceDriftsResponse) obj;
        return Objects.equals(stackResourceDrifts(), other.stackResourceDrifts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStackResourceDriftsResponse").add("StackResourceDrifts", stackResourceDrifts())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResourceDrifts":
            return Optional.ofNullable(clazz.cast(stackResourceDrifts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourceDriftsResponse, T> g) {
        return obj -> g.apply((DescribeStackResourceDriftsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackResourceDriftsResponse> {
        /**
         * <p>
         * Drift information for the resources that have been checked for drift in the specified stack. This includes
         * actual and expected configuration values for resources where AWS CloudFormation detects drift.
         * </p>
         * <p>
         * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
         * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
         * currently support drift detection are not checked, and so not included. For a list of resources that support
         * drift detection, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         * >Resources that Support Drift Detection</a>.
         * </p>
         * 
         * @param stackResourceDrifts
         *        Drift information for the resources that have been checked for drift in the specified stack. This
         *        includes actual and expected configuration values for resources where AWS CloudFormation detects
         *        drift.</p>
         *        <p>
         *        For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has
         *        been checked for drift. Resources that have not yet been checked for drift are not included. Resources
         *        that do not currently support drift detection are not checked, and so not included. For a list of
         *        resources that support drift detection, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         *        >Resources that Support Drift Detection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDrifts(Collection<StackResourceDrift> stackResourceDrifts);

        /**
         * <p>
         * Drift information for the resources that have been checked for drift in the specified stack. This includes
         * actual and expected configuration values for resources where AWS CloudFormation detects drift.
         * </p>
         * <p>
         * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
         * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
         * currently support drift detection are not checked, and so not included. For a list of resources that support
         * drift detection, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         * >Resources that Support Drift Detection</a>.
         * </p>
         * 
         * @param stackResourceDrifts
         *        Drift information for the resources that have been checked for drift in the specified stack. This
         *        includes actual and expected configuration values for resources where AWS CloudFormation detects
         *        drift.</p>
         *        <p>
         *        For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has
         *        been checked for drift. Resources that have not yet been checked for drift are not included. Resources
         *        that do not currently support drift detection are not checked, and so not included. For a list of
         *        resources that support drift detection, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         *        >Resources that Support Drift Detection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDrifts(StackResourceDrift... stackResourceDrifts);

        /**
         * <p>
         * Drift information for the resources that have been checked for drift in the specified stack. This includes
         * actual and expected configuration values for resources where AWS CloudFormation detects drift.
         * </p>
         * <p>
         * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
         * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
         * currently support drift detection are not checked, and so not included. For a list of resources that support
         * drift detection, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         * >Resources that Support Drift Detection</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackResourceDrift>.Builder} avoiding the
         * need to create one manually via {@link List<StackResourceDrift>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackResourceDrift>.Builder#build()} is called immediately
         * and its result is passed to {@link #stackResourceDrifts(List<StackResourceDrift>)}.
         * 
         * @param stackResourceDrifts
         *        a consumer that will call methods on {@link List<StackResourceDrift>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackResourceDrifts(List<StackResourceDrift>)
         */
        Builder stackResourceDrifts(Consumer<StackResourceDrift.Builder>... stackResourceDrifts);

        /**
         * <p>
         * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign that token
         * to the request object's <code>NextToken</code> parameter. If the request returns all results,
         * <code>NextToken</code> is set to <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token.
         *        To retrieve the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign
         *        that token to the request object's <code>NextToken</code> parameter. If the request returns all
         *        results, <code>NextToken</code> is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackResourceDrift> stackResourceDrifts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourceDriftsResponse model) {
            super(model);
            stackResourceDrifts(model.stackResourceDrifts);
            nextToken(model.nextToken);
        }

        public final Collection<StackResourceDrift.Builder> getStackResourceDrifts() {
            return stackResourceDrifts != null ? stackResourceDrifts.stream().map(StackResourceDrift::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackResourceDrifts(Collection<StackResourceDrift> stackResourceDrifts) {
            this.stackResourceDrifts = StackResourceDriftsCopier.copy(stackResourceDrifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDrifts(StackResourceDrift... stackResourceDrifts) {
            stackResourceDrifts(Arrays.asList(stackResourceDrifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDrifts(Consumer<StackResourceDrift.Builder>... stackResourceDrifts) {
            stackResourceDrifts(Stream.of(stackResourceDrifts).map(c -> StackResourceDrift.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStackResourceDrifts(Collection<StackResourceDrift.BuilderImpl> stackResourceDrifts) {
            this.stackResourceDrifts = StackResourceDriftsCopier.copyFromBuilder(stackResourceDrifts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeStackResourceDriftsResponse build() {
            return new DescribeStackResourceDriftsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
