/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.Stack;

public final class DescribeStacksPaginator
implements SdkIterable<DescribeStacksResponse> {
    private final CloudFormationClient client;
    private final DescribeStacksRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeStacksPaginator(CloudFormationClient client, DescribeStacksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStacksResponseFetcher();
    }

    public Iterator<DescribeStacksResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Stack> stacks() {
        Function<DescribeStacksResponse, Iterator> getIterator = response -> response != null ? response.stacks().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeStacksResponseFetcher
    implements NextPageFetcher<DescribeStacksResponse> {
        private DescribeStacksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStacksResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeStacksResponse nextPage(DescribeStacksResponse previousPage) {
            if (previousPage == null) {
                return DescribeStacksPaginator.this.client.describeStacks(DescribeStacksPaginator.this.firstRequest);
            }
            return DescribeStacksPaginator.this.client.describeStacks((DescribeStacksRequest)((Object)DescribeStacksPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

